/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common.connections;

import com.google.common.reflect.TypeToken;
import de.the_build_craft.maplink.common.AbstractModInitializer;
import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.HTTP;
import de.the_build_craft.maplink.common.ModConfig;
import de.the_build_craft.maplink.common.UpdateTask;
import de.the_build_craft.maplink.common.clientMapHandlers.ClientMapHandler;
import de.the_build_craft.maplink.common.configurations.SquareMapConfiguration;
import de.the_build_craft.maplink.common.connections.MapConnection;
import de.the_build_craft.maplink.common.mapUpdates.SquareMapMarkerUpdate;
import de.the_build_craft.maplink.common.mapUpdates.SquareMapPlayerUpdate;
import de.the_build_craft.maplink.common.mapUpdates.SquareMapWorldSettings;
import de.the_build_craft.maplink.common.waypoints.AreaMarker;
import de.the_build_craft.maplink.common.waypoints.Color;
import de.the_build_craft.maplink.common.waypoints.Int3;
import de.the_build_craft.maplink.common.waypoints.MarkerLayer;
import de.the_build_craft.maplink.common.waypoints.PlayerPosition;
import de.the_build_craft.maplink.common.waypoints.Position;
import de.the_build_craft.maplink.common.wrappers.Utils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SquareMapConnection
extends MapConnection {
    private String markerStringTemplate = "";
    private String markerIconLinkTemplate = "";
    private String worldSettingsLinkTemplate = "";
    String lastMarkerDimension = "";
    int lastMarkerHash;
    int lastAreaMarkerHash;
    List<Position> positions = new ArrayList<Position>();
    List<AreaMarker> areaMarkers = new ArrayList<AreaMarker>();

    public SquareMapConnection(ModConfig.ServerEntry serverEntry, UpdateTask updateTask) throws IOException {
        try {
            this.generateLink(serverEntry, true);
        }
        catch (Exception ignored) {
            try {
                this.generateLink(serverEntry, false);
            }
            catch (Exception e) {
                if (!updateTask.linkBrokenErrorWasShown) {
                    updateTask.linkBrokenErrorWasShown = true;
                    Utils.sendErrorToClientChat("[Map Link]: Error: Your Squaremap link is broken!");
                }
                throw e;
            }
        }
    }

    public SquareMapConnection(String baseURL, String link, boolean partOfLifeAtlas) throws IOException {
        this.partOfLiveAtlas = partOfLifeAtlas;
        Matcher matcher = Pattern.compile(".*?//\\w*(\\.\\w+)+(:\\w+)?").matcher(baseURL);
        if (!matcher.find()) {
            throw new RuntimeException("wrong url pattern");
        }
        baseURL = matcher.group();
        if (link.contains("//")) {
            baseURL = link;
        } else {
            if (!link.startsWith("/")) {
                link = "/" + link;
            }
            baseURL = baseURL + link;
        }
        if (baseURL.endsWith("/")) {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        this.setup(baseURL);
    }

    private void generateLink(ModConfig.ServerEntry serverEntry, boolean useHttps) throws IOException {
        this.setup(this.getBaseURL(serverEntry, useHttps));
    }

    private void setup(String baseURL) throws IOException {
        this.queryURL = URI.create(baseURL + "/tiles/players.json").toURL();
        this.markerStringTemplate = baseURL + "/tiles/{world}/markers.json";
        this.markerIconLinkTemplate = baseURL + "/images/icon/registered/{icon}.png";
        this.onlineMapConfigLink = baseURL + "/tiles/settings.json";
        this.worldSettingsLinkTemplate = baseURL + "/tiles/{world}/settings.json";
        this.getPlayerPositions();
        AbstractModInitializer.LOGGER.info("new link: " + this.queryURL);
        if (CommonModConfig.config.general.debugMode) {
            Utils.sendToClientChat("new link: " + this.queryURL);
        }
        this.setUpdateDelay();
    }

    private void setUpdateDelay() {
        try {
            SquareMapConfiguration squareMapConfiguration = HTTP.makeJSONHTTPRequest(URI.create(this.onlineMapConfigLink).toURL(), SquareMapConfiguration.class);
            float updateDelay = 1.0f;
            for (SquareMapConfiguration.World world : squareMapConfiguration.worlds) {
                SquareMapWorldSettings squareMapWorldSettings = HTTP.makeJSONHTTPRequest(URI.create(this.worldSettingsLinkTemplate.replace("{world}", world.name)).toURL(), SquareMapWorldSettings.class);
                updateDelay = Math.max(updateDelay, squareMapWorldSettings.player_tracker.update_interval);
            }
            UpdateTask.nextUpdateDelay = Math.max(UpdateTask.nextUpdateDelay, (int)Math.ceil(updateDelay * 1000.0f));
        }
        catch (Exception e) {
            AbstractModInitializer.LOGGER.error("Error getting update Delay! Using the Default of 1000 ms for SquareMap.", (Throwable)e);
            UpdateTask.nextUpdateDelay = Math.max(UpdateTask.nextUpdateDelay, 1000);
        }
    }

    @Override
    public HashMap<String, PlayerPosition> getPlayerPositions() throws IOException {
        SquareMapPlayerUpdate update = HTTP.makeJSONHTTPRequest(this.queryURL, SquareMapPlayerUpdate.class);
        PlayerPosition[] positions = new PlayerPosition[update.players.length];
        for (int i = 0; i < update.players.length; ++i) {
            SquareMapPlayerUpdate.Player player = update.players[i];
            PlayerPosition playerPosition = new PlayerPosition(player.name, player.x, player.y == Integer.MIN_VALUE ? CommonModConfig.config.general.defaultY : player.y, player.z, player.world);
            ClientMapHandler.registerPlayerPosition(playerPosition, "https://mc-heads.net/avatar/" + player.uuid + "/32");
            positions[i] = playerPosition;
        }
        return this.HandlePlayerPositions(positions);
    }

    @Override
    public Set<String> getMarkerLayers() {
        try {
            Type apiResponseType = new TypeToken<SquareMapMarkerUpdate[]>(){}.getType();
            HashSet<String> layers = new HashSet<String>();
            SquareMapConfiguration squareMapConfiguration = HTTP.makeJSONHTTPRequest(URI.create(this.onlineMapConfigLink).toURL(), SquareMapConfiguration.class);
            for (SquareMapConfiguration.World world : squareMapConfiguration.worlds) {
                SquareMapMarkerUpdate[] ml;
                for (SquareMapMarkerUpdate markerLayer : ml = (SquareMapMarkerUpdate[])HTTP.makeJSONHTTPRequest(URI.create(this.markerStringTemplate.replace("{world}", world.name)).toURL(), apiResponseType)) {
                    layers.add(markerLayer.id);
                }
            }
            return layers;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void getWaypointPositions(boolean forceRefresh) throws IOException {
        if (this.markerStringTemplate.isEmpty() || this.currentDimension.isEmpty()) {
            if (ClientMapHandler.getInstance() != null) {
                ClientMapHandler.getInstance().removeAllMarkerWaypoints();
                ClientMapHandler.getInstance().removeAllAreaMarkers(true);
            }
            return;
        }
        ModConfig.ServerEntry serverEntry = CommonModConfig.getCurrentServerEntry();
        if (serverEntry.needsMarkerLayerUpdate() && !this.partOfLiveAtlas) {
            serverEntry.setMarkerLayers(new ArrayList<String>(this.getMarkerLayers()));
        }
        if (ClientMapHandler.getInstance() == null) {
            return;
        }
        int newMarkerHash = serverEntry.getMarkerVisibilityHash();
        int newAreaMarkerHash = serverEntry.getAreaMarkerVisibilityHash();
        if (this.lastMarkerDimension.equals(this.currentDimension) && newMarkerHash == this.lastMarkerHash && newAreaMarkerHash == this.lastAreaMarkerHash && !forceRefresh) {
            ClientMapHandler.getInstance().handleMarkerWaypoints(this.positions);
            return;
        }
        this.lastMarkerDimension = this.currentDimension;
        this.lastMarkerHash = newMarkerHash;
        this.lastAreaMarkerHash = newAreaMarkerHash;
        Type apiResponseType = new TypeToken<SquareMapMarkerUpdate[]>(){}.getType();
        URL reqUrl = URI.create(this.markerStringTemplate.replace("{world}", this.currentDimension)).toURL();
        SquareMapMarkerUpdate[] markersLayers = (SquareMapMarkerUpdate[])HTTP.makeJSONHTTPRequest(reqUrl, apiResponseType);
        this.positions.clear();
        this.areaMarkers.clear();
        for (SquareMapMarkerUpdate markerLayer : markersLayers) {
            for (SquareMapMarkerUpdate.Marker marker : markerLayer.markers) {
                if (Objects.equals(marker.type, "icon") && serverEntry.includeMarkerLayer(markerLayer.id) && serverEntry.includeMarker(marker.tooltip)) {
                    Position position = new Position(marker.tooltip, marker.point.x, CommonModConfig.config.general.defaultY, marker.point.z, this.currentDimension + markerLayer.id + marker.tooltip + marker.point.x + marker.point.z, new MarkerLayer(markerLayer.id, markerLayer.name));
                    this.positions.add(position);
                    ClientMapHandler.registerPosition(position, this.markerIconLinkTemplate.replace("{icon}", marker.icon));
                    continue;
                }
                if (!Objects.equals(marker.type, "polygon") || !serverEntry.includeAreaMarkerLayer(markerLayer.id) || !serverEntry.includeAreaMarker(marker.tooltip)) continue;
                this.areaMarkers.add(new AreaMarker(marker.tooltip, 0, 0, 0, (Int3[][])Arrays.stream(marker.points).flatMap(Arrays::stream).toArray(x$0 -> new Int3[x$0][]), new Color(marker.color, 1.0f), new Color(marker.fillColor, marker.opacity), this.currentDimension + markerLayer.id + marker.tooltip + Arrays.deepHashCode((Object[])marker.points), new MarkerLayer(markerLayer.id, markerLayer.name)));
            }
        }
        ClientMapHandler.getInstance().handleMarkerWaypoints(this.positions);
        ClientMapHandler.getInstance().handleAreaMarkers(this.areaMarkers);
    }
}

