/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common.mapUpdates;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.the_build_craft.maplink.common.waypoints.Int3;
import java.io.IOException;
import java.util.ArrayList;

public class SquareMapMarkerUpdate {
    public String name;
    public String id;
    public Marker[] markers = new Marker[0];

    public static class Marker {
        public Int3 point;
        public String tooltip;
        public String type;
        @JsonAdapter(value=PointsAdapterFactory.class)
        public Int3[][][] points = new Int3[0][][];
        public String fillColor;
        public String color;
        public float opacity = 0.5f;
        public String icon = "";
    }

    public static class PointsAdapter
    extends TypeAdapter<Int3[][][]> {
        private final Gson gson;

        public PointsAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter jsonWriter, Int3[][][] int3s) {
            throw new RuntimeException("Not implemented");
        }

        public Int3[][][] read(JsonReader jsonReader) throws IOException {
            Int3[][][] result;
            jsonReader.beginArray();
            switch (jsonReader.peek()) {
                case BEGIN_ARRAY: {
                    result = this.read2dOr3dArray(jsonReader);
                    break;
                }
                case BEGIN_OBJECT: {
                    result = new Int3[][][]{{this.readArray(jsonReader)}};
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            jsonReader.endArray();
            return result;
        }

        Int3[] readArray(JsonReader jsonReader) throws IOException {
            ArrayList<Int3> list = new ArrayList<Int3>();
            while (jsonReader.hasNext()) {
                list.add((Int3)this.gson.fromJson(jsonReader, Int3.class));
            }
            Int3[] arr = new Int3[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                arr[i] = (Int3)list.get(i);
            }
            return arr;
        }

        Int3[][][] read2dOr3dArray(JsonReader jsonReader) throws IOException {
            ArrayList<Int3[][]> list = new ArrayList<Int3[][]>();
            while (jsonReader.hasNext()) {
                jsonReader.beginArray();
                switch (jsonReader.peek()) {
                    case BEGIN_ARRAY: {
                        ArrayList<Int3[]> list2 = new ArrayList<Int3[]>();
                        while (jsonReader.hasNext()) {
                            jsonReader.beginArray();
                            list2.add(this.readArray(jsonReader));
                            jsonReader.endArray();
                        }
                        Int3[][] arr = new Int3[list2.size()][];
                        for (int i = 0; i < list2.size(); ++i) {
                            arr[i] = (Int3[])list2.get(i);
                        }
                        list.add(arr);
                        break;
                    }
                    case BEGIN_OBJECT: {
                        list.add(new Int3[][]{this.readArray(jsonReader)});
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                jsonReader.endArray();
            }
            Int3[][][] arr = new Int3[list.size()][][];
            for (int i = 0; i < list.size(); ++i) {
                arr[i] = (Int3[][])list.get(i);
            }
            return arr;
        }
    }

    public static class PointsAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return new PointsAdapter(gson);
        }
    }
}

