/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common.connections;

import com.google.common.reflect.TypeToken;
import de.the_build_craft.maplink.common.AbstractModInitializer;
import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.HTTP;
import de.the_build_craft.maplink.common.ModConfig;
import de.the_build_craft.maplink.common.UpdateTask;
import de.the_build_craft.maplink.common.clientMapHandlers.ClientMapHandler;
import de.the_build_craft.maplink.common.configurations.BlueMapConfiguration;
import de.the_build_craft.maplink.common.connections.MapConnection;
import de.the_build_craft.maplink.common.mapUpdates.BlueMapMarkerSet;
import de.the_build_craft.maplink.common.mapUpdates.BlueMapPlayerUpdate;
import de.the_build_craft.maplink.common.waypoints.AreaMarker;
import de.the_build_craft.maplink.common.waypoints.Double3;
import de.the_build_craft.maplink.common.waypoints.MarkerLayer;
import de.the_build_craft.maplink.common.waypoints.PlayerPosition;
import de.the_build_craft.maplink.common.waypoints.Position;
import de.the_build_craft.maplink.common.wrappers.Utils;
import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BlueMapConnection
extends MapConnection {
    List<Integer> lastWorldIndices = new ArrayList<Integer>(Collections.singletonList(0));
    List<URL> playerUrls = new ArrayList<URL>();
    List<URL> markerUrls = new ArrayList<URL>();
    List<String> worlds = new ArrayList<String>();
    List<String> playerHeadIconUrlTemplates = new ArrayList<String>();
    private String markerIconLinkTemplate = "";
    int lastWorldIndicesHash;
    int lastMarkerHash;
    int lastAreaMarkerHash;
    List<Position> positions = new ArrayList<Position>();
    List<AreaMarker> areaMarkers = new ArrayList<AreaMarker>();
    private boolean correctWorld = false;

    public BlueMapConnection(ModConfig.ServerEntry serverEntry, UpdateTask updateTask) throws IOException {
        try {
            this.generateLinks(serverEntry, true);
        }
        catch (Exception suppressed) {
            try {
                this.generateLinks(serverEntry, false);
            }
            catch (Exception e) {
                if (!updateTask.linkBrokenErrorWasShown) {
                    updateTask.linkBrokenErrorWasShown = true;
                    Utils.sendErrorToClientChat("[Map Link]: Error: Your Bluemap link is broken!");
                }
                e.addSuppressed(suppressed);
                throw e;
            }
        }
    }

    private void generateLinks(ModConfig.ServerEntry serverEntry, boolean useHttps) throws IOException {
        this.playerUrls.clear();
        this.markerUrls.clear();
        this.worlds.clear();
        this.playerHeadIconUrlTemplates.clear();
        String baseURL = this.getBaseURL(serverEntry, useHttps);
        AbstractModInitializer.LOGGER.info("baseURL " + baseURL);
        for (String w : HTTP.makeJSONHTTPRequest((URL)URI.create((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001/settings.json?"}, (String)baseURL))).toURL(), BlueMapConfiguration.class).maps) {
            this.playerUrls.add(URI.create((baseURL + "/maps/" + w + "/live/players.json?").replace(" ", "%20")).toURL());
            this.markerUrls.add(URI.create((baseURL + "/maps/" + w + "/live/markers.json?").replace(" ", "%20")).toURL());
            this.worlds.add(w);
            this.playerHeadIconUrlTemplates.add(baseURL + "/maps/" + w + "/assets/playerheads/{uuid}.png");
        }
        this.onlineMapConfigLink = baseURL + "/settings.json?";
        this.markerIconLinkTemplate = baseURL + "/{icon}";
        this.getPlayerPositions();
        for (URL url : this.playerUrls) {
            AbstractModInitializer.LOGGER.info("new player link: " + String.valueOf(url));
            if (!CommonModConfig.config.general.debugMode) continue;
            Utils.sendToClientChat("new link: " + String.valueOf(url));
        }
        for (URL url : this.markerUrls) {
            AbstractModInitializer.LOGGER.info("new marker link: " + String.valueOf(url));
            if (!CommonModConfig.config.general.debugMode) continue;
            Utils.sendToClientChat("new link: " + String.valueOf(url));
        }
        UpdateTask.nextUpdateDelay = 1000;
    }

    @Override
    public Set<String> getMarkerLayers() {
        Type apiResponseType = new TypeToken<Map<String, BlueMapMarkerSet>>(){}.getType();
        HashSet<String> layers = new HashSet<String>();
        for (URL url : this.markerUrls) {
            Map sets;
            try {
                sets = (Map)HTTP.makeJSONHTTPRequest(url, apiResponseType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            layers.addAll(sets.keySet());
        }
        return layers;
    }

    @Override
    public void getWaypointPositions(boolean forceRefresh) throws IOException {
        Type apiResponseType = new TypeToken<Map<String, BlueMapMarkerSet>>(){}.getType();
        ModConfig.ServerEntry serverEntry = CommonModConfig.getCurrentServerEntry();
        if (serverEntry.needsMarkerLayerUpdate()) {
            serverEntry.setMarkerLayers(new ArrayList<String>(this.getMarkerLayers()));
        }
        if (ClientMapHandler.getInstance() == null) {
            return;
        }
        int newWorldIndicesHash = this.lastWorldIndices.hashCode();
        int newMarkerHash = serverEntry.getMarkerVisibilityHash();
        int newAreaMarkerHash = serverEntry.getAreaMarkerVisibilityHash();
        if (newWorldIndicesHash == this.lastWorldIndicesHash && newMarkerHash == this.lastMarkerHash && newAreaMarkerHash == this.lastAreaMarkerHash && !forceRefresh) {
            ClientMapHandler.getInstance().handleMarkerWaypoints(this.positions);
            return;
        }
        this.lastWorldIndicesHash = newWorldIndicesHash;
        this.lastMarkerHash = newMarkerHash;
        this.lastAreaMarkerHash = newAreaMarkerHash;
        this.positions.clear();
        this.areaMarkers.clear();
        for (int i : this.lastWorldIndices) {
            Map markerSets = (Map)HTTP.makeJSONHTTPRequest(this.markerUrls.get(i), apiResponseType);
            for (Map.Entry markerSetEntry : markerSets.entrySet()) {
                if (CommonModConfig.config.general.debugMode && CommonModConfig.config.general.chatLogInDebugMode) {
                    Utils.sendToClientChat("====================================");
                    Utils.sendToClientChat("markerSet: " + (String)markerSetEntry.getKey());
                }
                for (Map.Entry<String, BlueMapMarkerSet.Marker> markerEntry : ((BlueMapMarkerSet)markerSetEntry.getValue()).markers.entrySet()) {
                    BlueMapMarkerSet.Marker marker = markerEntry.getValue();
                    Double3 pos = marker.position;
                    if (Objects.equals(marker.type, "poi") || Objects.equals(marker.type, "html")) {
                        if (!serverEntry.includeMarkerLayer((String)markerSetEntry.getKey()) || !serverEntry.includeMarker(marker.label)) continue;
                        Position position = new Position(marker.label, pos.x, pos.y, pos.z, i + (String)markerSetEntry.getKey() + markerEntry.getKey(), new MarkerLayer((String)markerSetEntry.getKey(), ((BlueMapMarkerSet)markerSetEntry.getValue()).label));
                        this.positions.add(position);
                        ClientMapHandler.registerPosition(position, (String)(marker.icon.startsWith("http") ? marker.icon : (marker.icon.equals("assets/poi.svg") ? null : this.markerIconLinkTemplate.replace("{icon}", marker.icon))));
                        continue;
                    }
                    if (!Objects.equals(marker.type, "shape") && !Objects.equals(marker.type, "extrude") || !serverEntry.includeAreaMarkerLayer((String)markerSetEntry.getKey()) || !serverEntry.includeAreaMarker(marker.label)) continue;
                    this.areaMarkers.add(new AreaMarker(marker.label, pos.x, pos.y, pos.z, marker.shape, marker.lineColor, marker.fillColor, i + (String)markerSetEntry.getKey() + markerEntry.getKey(), new MarkerLayer((String)markerSetEntry.getKey(), ((BlueMapMarkerSet)markerSetEntry.getValue()).label)));
                }
            }
        }
        ClientMapHandler.getInstance().handleMarkerWaypoints(this.positions);
        ClientMapHandler.getInstance().handleAreaMarkers(this.areaMarkers);
    }

    @Override
    public HashMap<String, PlayerPosition> getPlayerPositions() throws IOException {
        assert (this.mc.player != null);
        String clientName = this.mc.player.getName().getString();
        this.correctWorld = false;
        BlueMapPlayerUpdate update = null;
        if (AbstractModInitializer.overwriteCurrentDimension && !Objects.equals(this.currentDimension, "")) {
            this.lastWorldIndices.clear();
            this.lastWorldIndices.add(this.worlds.indexOf(this.currentDimension));
            update = HTTP.makeJSONHTTPRequest(this.playerUrls.get(this.lastWorldIndices.get(0)), BlueMapPlayerUpdate.class);
        } else {
            if (!this.lastWorldIndices.isEmpty()) {
                update = this.getBlueMapPlayerUpdate(clientName, update, this.lastWorldIndices.get(0));
            }
            if (!this.correctWorld) {
                this.lastWorldIndices.clear();
                for (int i = 0; i < this.playerUrls.size(); ++i) {
                    this.correctWorld = false;
                    update = this.getBlueMapPlayerUpdate(clientName, update, i);
                    if (!this.correctWorld) continue;
                    this.lastWorldIndices.add(i);
                }
            }
        }
        boolean bl = this.correctWorld = !this.lastWorldIndices.isEmpty();
        if (update == null || this.playerUrls.isEmpty()) {
            throw new IllegalStateException("Can't get player positions. All Bluemap links are broken!");
        }
        PlayerPosition[] positions = new PlayerPosition[update.players.length];
        for (int i = 0; i < update.players.length; ++i) {
            PlayerPosition playerPosition;
            BlueMapPlayerUpdate.Player player = update.players[i];
            positions[i] = playerPosition = new PlayerPosition(player.name, player.position.x, player.position.y, player.position.z, this.correctWorld ? (player.foreign ? "foreign" : "thisWorld") : "unknown");
            if (!this.correctWorld) continue;
            ClientMapHandler.registerPlayerPosition(playerPosition, this.playerHeadIconUrlTemplates.get(this.lastWorldIndices.get(0)).replace("{uuid}", player.uuid));
        }
        return this.HandlePlayerPositions(positions);
    }

    private BlueMapPlayerUpdate getBlueMapPlayerUpdate(String clientName, BlueMapPlayerUpdate update, int worldIndex) {
        try {
            update = HTTP.makeJSONHTTPRequest(this.playerUrls.get(worldIndex), BlueMapPlayerUpdate.class);
            for (BlueMapPlayerUpdate.Player p : update.players) {
                if (!Objects.equals(p.name, clientName)) continue;
                this.correctWorld = !p.foreign;
                break;
            }
        }
        catch (Exception ignored) {
            if (CommonModConfig.config.general.debugMode) {
                Utils.sendToClientChat("removed broken link: " + String.valueOf(this.playerUrls.get(worldIndex)));
            }
            this.playerUrls.remove(worldIndex);
            this.markerUrls.remove(worldIndex);
            this.worlds.remove(worldIndex);
        }
        return update;
    }
}

