/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common.clientMapHandlers;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.FastUpdateTask;
import de.the_build_craft.maplink.common.HTTP;
import de.the_build_craft.maplink.common.ModConfig;
import de.the_build_craft.maplink.common.waypoints.AreaMarker;
import de.the_build_craft.maplink.common.waypoints.PlayerPosition;
import de.the_build_craft.maplink.common.waypoints.Position;
import de.the_build_craft.maplink.common.waypoints.WaypointState;
import de.the_build_craft.maplink.common.wrappers.Text;
import de.the_build_craft.maplink.common.wrappers.Utils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class ClientMapHandler {
    public static final String waypointPrefix = "maplink_";
    private static final Map<String, NativeImage> iconLinkToNativeImage = new HashMap<String, NativeImage>();
    private static final Map<String, DynamicTexture> iconLinkToTexture = new HashMap<String, DynamicTexture>();
    private static final Map<String, WaypointState> idToWaypointState = new ConcurrentHashMap<String, WaypointState>();
    private static ClientMapHandler instance;
    protected final Minecraft mc;
    private static final int maxMarkerCountBeforeWarning = 25;
    private boolean markerMessageWasShown = false;
    private int previousPlayerWaypointColor = 0;
    private int previousMarkerWaypointColor = 0;
    private int previousFriendWaypointColor = 0;
    private boolean previousFriendColorOverride = false;
    private int previousFriendListHashCode = 0;
    private final List<PlayerPosition> tempPlayerWaypointPositions = new ArrayList<PlayerPosition>();
    protected final Set<String> currentPlayerIds = new HashSet<String>();
    protected final Set<String> currentMarkerIds = new HashSet<String>();

    public ClientMapHandler() {
        instance = this;
        this.mc = Minecraft.m_91087_();
    }

    public static ClientMapHandler getInstance() {
        return instance;
    }

    public static WaypointState getWaypointState(String id) {
        return idToWaypointState.get(id);
    }

    public static void registerPlayerPosition(PlayerPosition playerPosition, String iconLink) {
        if (CommonModConfig.config.general.useMcHeadsPlayerNameIcons) {
            iconLink = "https://mc-heads.net/avatar/" + playerPosition.name + "/32";
        }
        ClientMapHandler.registerPosition(playerPosition, (String)iconLink, true, false);
    }

    public static void registerTempPlayerPosition(PlayerPosition playerPosition) {
        ClientMapHandler.registerPosition(playerPosition, "https://mc-heads.net/avatar/" + playerPosition.name + "/32", true, true);
    }

    public static void registerPosition(Position position, String iconLink) {
        ClientMapHandler.registerPosition(position, iconLink, false, false);
    }

    public static void registerPosition(Position position, String iconLink, boolean isPlayer, boolean isTemp) {
        WaypointState prev;
        WaypointState waypointState = idToWaypointState.get(position.id);
        if (waypointState != null && (!waypointState.isTemp || isTemp)) {
            return;
        }
        if (!iconLinkToNativeImage.containsKey(iconLink)) {
            try {
                NativeImage nativeImage;
                try {
                    nativeImage = HTTP.makeImageHttpRequest(URI.create(iconLink).toURL());
                }
                catch (Exception e) {
                    if (isPlayer) {
                        nativeImage = HTTP.makeImageHttpRequest(URI.create("https://mc-heads.net/avatar/" + position.name + "/32").toURL());
                    }
                    throw e;
                }
                if (nativeImage.m_84982_() == nativeImage.m_85084_() && nativeImage.m_84982_() <= 64) {
                    iconLinkToNativeImage.put(iconLink, nativeImage);
                } else {
                    NativeImage nativeImage1 = new NativeImage(64, 64, true);
                    nativeImage.m_85034_(0, 0, nativeImage.m_84982_(), nativeImage.m_85084_(), nativeImage1);
                    iconLinkToNativeImage.put(iconLink, nativeImage1);
                    nativeImage.close();
                }
            }
            catch (Exception e) {
                iconLink = null;
            }
        }
        if ((prev = idToWaypointState.put(position.id, new WaypointState(position.name, iconLink, isPlayer, isTemp))) != null) {
            prev.isOld = true;
        }
    }

    public static void clearRegisteredPositions() {
        idToWaypointState.clear();
    }

    public static DynamicTexture getDynamicTexture(String link) {
        if (iconLinkToTexture.containsKey(link)) {
            return iconLinkToTexture.get(link);
        }
        if (!iconLinkToNativeImage.containsKey(link)) {
            return null;
        }
        DynamicTexture texture = new DynamicTexture(iconLinkToNativeImage.get(link));
        texture.m_117960_(false, false);
        Minecraft.m_91087_().m_91097_().m_118495_(ClientMapHandler.getIconResourceLocation(link), (AbstractTexture)texture);
        DynamicTexture old = iconLinkToTexture.put(link, texture);
        if (old != null) {
            old.close();
        }
        return texture;
    }

    public static ResourceLocation getIconResourceLocation(String icon) {
        return ResourceLocation.m_214293_((String)"maplink", (String)("xaeros_" + ClientMapHandler.makeResourceSafeString(icon)));
    }

    public static String makeResourceSafeString(String original) {
        String hash = Hashing.sha1().hashUnencodedChars((CharSequence)original).toString();
        original = original.toLowerCase(Locale.ROOT);
        original = Util.m_137483_((String)original, ResourceLocation::m_135828_);
        return original + "/" + hash;
    }

    public void handlePlayerWaypoints() {
        if (this.mc.f_91075_ == null || this.mc.f_91073_ == null) {
            return;
        }
        if (CommonModConfig.config.general.enablePlayerWaypoints) {
            this.currentPlayerIds.clear();
            Map<String, AbstractClientPlayer> playerClientEntityMap = this.mc.f_91073_.m_6907_().stream().collect(Collectors.toMap(a -> a.m_36316_().getName(), a -> a));
            int maxHudD = CommonModConfig.config.hud.maxPlayerDistance;
            int minMiniD = CommonModConfig.config.minimap.minPlayerDistance;
            int maxMiniD = CommonModConfig.config.minimap.maxPlayerDistance;
            int minWorldD = CommonModConfig.config.worldmap.minPlayerDistance;
            int maxWorldD = CommonModConfig.config.worldmap.maxPlayerDistance;
            int minIconHudD = CommonModConfig.config.hud.minPlayerIconDistance;
            int maxIconHudD = CommonModConfig.config.hud.maxPlayerIconDistance;
            int minIconMiniD = CommonModConfig.config.minimap.minPlayerIconDistance;
            int maxIconMiniD = CommonModConfig.config.minimap.maxPlayerIconDistance;
            int minIconWorldD = CommonModConfig.config.worldmap.minPlayerIconDistance;
            int maxIconWorldD = CommonModConfig.config.worldmap.maxPlayerIconDistance;
            int onHud = 0;
            int maxOnHud = CommonModConfig.config.hud.maxPlayerWaypoints;
            int onMiniMap = 0;
            int maxOnMiniMap = CommonModConfig.config.minimap.maxPlayerWaypoints;
            int onWorldMap = 0;
            int maxOnWorldMap = CommonModConfig.config.worldmap.maxPlayerWaypoints;
            int iconsOnHud = 0;
            int maxIconsOnHud = CommonModConfig.config.hud.maxPlayerIconWaypoints;
            int iconsOnMiniMap = 0;
            int maxIconsOnMiniMap = CommonModConfig.config.minimap.maxPlayerIconWaypoints;
            int iconsOnWorldMap = 0;
            int maxIconsOnWorldMap = CommonModConfig.config.worldmap.maxPlayerIconWaypoints;
            boolean onlyShowFriends = CommonModConfig.config.friends.onlyShowFriendsWaypoints;
            boolean onlyShowFriendsIcons = CommonModConfig.config.friends.onlyShowFriendsIconWaypoints;
            boolean alwaysShowFriends = CommonModConfig.config.friends.alwaysShowFriendsWaypoints;
            boolean alwaysShowFriendIcons = CommonModConfig.config.friends.alwaysShowFriendsIconWaypoints;
            boolean enablePlayerIcons = CommonModConfig.config.general.enablePlayerIconWaypoints;
            Vec3 cameraPos = this.mc.f_91075_.m_20182_();
            this.tempPlayerWaypointPositions.clear();
            this.tempPlayerWaypointPositions.addAll(FastUpdateTask.playerPositions.values());
            this.tempPlayerWaypointPositions.sort(Comparator.comparing(p -> cameraPos.m_82531_(p.pos.x, p.pos.y, p.pos.z)));
            for (PlayerPosition playerPosition : this.tempPlayerWaypointPositions) {
                if (playerPosition == null) continue;
                String playerName = playerPosition.name;
                WaypointState waypointState = idToWaypointState.get(playerPosition.id);
                boolean isFriend = CommonModConfig.config.friends.friendList.contains(playerName);
                if (onlyShowFriends && !isFriend) continue;
                waypointState.renderOnHud = CommonModConfig.config.hud.showPlayerWaypoints != ModConfig.ConditionalActiveMode.NEVER;
                waypointState.renderOnMiniMap = CommonModConfig.config.minimap.showPlayerWaypoints != ModConfig.ConditionalActiveMode.NEVER;
                waypointState.renderOnWorldMap = CommonModConfig.config.worldmap.showPlayerWaypoints != ModConfig.ConditionalActiveMode.NEVER;
                int minHudD = CommonModConfig.config.hud.minNotVisiblePlayerDistance;
                if (playerClientEntityMap.containsKey(playerName)) {
                    ClipContext clipContext;
                    if (CommonModConfig.config.hud.hidePlayersInRange) {
                        waypointState.renderOnHud = false;
                    }
                    if (CommonModConfig.config.minimap.hidePlayersInRange) {
                        waypointState.renderOnMiniMap = false;
                    }
                    if (CommonModConfig.config.worldmap.hidePlayersInRange) {
                        waypointState.renderOnWorldMap = false;
                    }
                    if (waypointState.renderOnHud && this.mc.f_91073_.m_45547_(clipContext = new ClipContext(this.mc.f_91075_.m_146892_(), playerClientEntityMap.get(playerName).m_20182_().m_82520_(0.0, 1.0, 0.0), ClipContext.Block.VISUAL, ClipContext.Fluid.ANY, this.mc.f_91075_)).m_6662_() != HitResult.Type.BLOCK) {
                        if (CommonModConfig.config.hud.hidePlayersVisible) {
                            waypointState.renderOnHud = false;
                        }
                        minHudD = CommonModConfig.config.hud.minVisiblePlayerDistance;
                    }
                }
                double d = cameraPos.m_82554_(new Vec3(playerPosition.pos.x, playerPosition.pos.y, playerPosition.pos.z));
                if (alwaysShowFriends && isFriend) {
                    waypointState.renderOnHud = waypointState.renderOnHud & d >= (double)minHudD;
                } else {
                    waypointState.renderOnHud = waypointState.renderOnHud & (onHud < maxOnHud && d >= (double)minHudD && d <= (double)maxHudD);
                    waypointState.renderOnMiniMap = waypointState.renderOnMiniMap & (onMiniMap < maxOnMiniMap && d >= (double)minMiniD && d <= (double)maxMiniD);
                    waypointState.renderOnWorldMap = waypointState.renderOnWorldMap & (onWorldMap < maxOnWorldMap && d >= (double)minWorldD && d <= (double)maxWorldD);
                    if (waypointState.renderOnHud) {
                        ++onHud;
                    }
                    if (waypointState.renderOnMiniMap) {
                        ++onMiniMap;
                    }
                    if (waypointState.renderOnWorldMap) {
                        ++onWorldMap;
                    }
                }
                if (!waypointState.renderOnHud && !waypointState.renderOnMiniMap && !waypointState.renderOnWorldMap) continue;
                if (!enablePlayerIcons || !waypointState.hasIcon) {
                    waypointState.renderIconOnHud = false;
                    waypointState.renderIconOnMiniMap = false;
                    waypointState.renderIconOnWorldMap = false;
                } else if (alwaysShowFriendIcons && isFriend) {
                    waypointState.renderIconOnHud = true;
                    waypointState.renderIconOnMiniMap = true;
                    waypointState.renderIconOnWorldMap = true;
                } else {
                    waypointState.renderIconOnHud = iconsOnHud < maxIconsOnHud && d >= (double)minIconHudD && d <= (double)maxIconHudD;
                    waypointState.renderIconOnMiniMap = iconsOnMiniMap < maxIconsOnMiniMap && d >= (double)minIconMiniD && d <= (double)maxIconMiniD;
                    boolean bl = waypointState.renderIconOnWorldMap = iconsOnWorldMap < maxIconsOnWorldMap && d >= (double)minIconWorldD && d <= (double)maxIconWorldD;
                    if (onlyShowFriendsIcons) {
                        waypointState.renderIconOnHud &= isFriend;
                        waypointState.renderIconOnMiniMap &= isFriend;
                        waypointState.renderIconOnWorldMap &= isFriend;
                    }
                    if (waypointState.renderIconOnHud) {
                        ++iconsOnHud;
                    }
                    if (waypointState.renderIconOnMiniMap) {
                        ++iconsOnMiniMap;
                    }
                    if (waypointState.renderIconOnWorldMap) {
                        ++iconsOnWorldMap;
                    }
                }
                if (!waypointState.renderOnHud && !waypointState.renderOnMiniMap && !waypointState.renderOnWorldMap) continue;
                this.currentPlayerIds.add(playerPosition.id);
                if (CommonModConfig.config.general.showPlayerWaypointsAsTrackedPlayers) continue;
                this.addOrUpdatePlayerWaypoint(playerPosition, waypointState);
            }
            this.removeOldPlayerWaypoints();
            int newPlayerWaypointColor = CommonModConfig.config.general.playerWaypointColor.ordinal();
            int newFriendWaypointColor = CommonModConfig.config.friends.friendWaypointColor.ordinal();
            boolean newFriendColorOverride = CommonModConfig.config.friends.overwriteFriendWaypointColor;
            int newFriendListHashCode = CommonModConfig.config.friends.friendList.hashCode();
            if (this.previousPlayerWaypointColor != newPlayerWaypointColor || this.previousFriendWaypointColor != newFriendWaypointColor || this.previousFriendColorOverride != newFriendColorOverride || this.previousFriendListHashCode != newFriendListHashCode) {
                this.previousPlayerWaypointColor = newPlayerWaypointColor;
                this.previousFriendWaypointColor = newFriendWaypointColor;
                this.previousFriendColorOverride = newFriendColorOverride;
                this.previousFriendListHashCode = newFriendListHashCode;
                this.updatePlayerWaypointColors();
            }
        } else {
            this.removeAllPlayerWaypoints();
        }
    }

    public abstract void reset();

    abstract void addOrUpdatePlayerWaypoint(PlayerPosition var1, WaypointState var2);

    abstract void removeOldPlayerWaypoints();

    abstract void removeAllPlayerWaypoints();

    abstract void updatePlayerWaypointColors();

    public void handleMarkerWaypoints(List<Position> markerPositions) {
        if (this.mc.f_91075_ == null) {
            return;
        }
        ModConfig.ServerEntry serverEntry = CommonModConfig.getCurrentServerEntry();
        if (CommonModConfig.config.general.enableMarkerWaypoints && serverEntry != null) {
            this.currentMarkerIds.clear();
            int minHudD = CommonModConfig.config.hud.minMarkerDistance;
            int maxHudD = CommonModConfig.config.hud.maxMarkerDistance;
            int minMiniD = CommonModConfig.config.minimap.minMarkerDistance;
            int maxMiniD = CommonModConfig.config.minimap.maxMarkerDistance;
            int minWorldD = CommonModConfig.config.worldmap.minMarkerDistance;
            int maxWorldD = CommonModConfig.config.worldmap.maxMarkerDistance;
            int minIconHudD = CommonModConfig.config.hud.minMarkerIconDistance;
            int maxIconHudD = CommonModConfig.config.hud.maxMarkerIconDistance;
            int minIconMiniD = CommonModConfig.config.minimap.minMarkerIconDistance;
            int maxIconMiniD = CommonModConfig.config.minimap.maxMarkerIconDistance;
            int minIconWorldD = CommonModConfig.config.worldmap.minMarkerIconDistance;
            int maxIconWorldD = CommonModConfig.config.worldmap.maxMarkerIconDistance;
            int onHud = 0;
            int maxOnHud = CommonModConfig.config.hud.maxMarkerWaypoints;
            int onMiniMap = 0;
            int maxOnMiniMap = CommonModConfig.config.minimap.maxMarkerWaypoints;
            int onWorldMap = 0;
            int maxOnWorldMap = CommonModConfig.config.worldmap.maxMarkerWaypoints;
            int iconsOnHud = 0;
            int maxIconsOnHud = CommonModConfig.config.hud.maxMarkerIconWaypoints;
            int iconsOnMiniMap = 0;
            int maxIconsOnMiniMap = CommonModConfig.config.minimap.maxMarkerIconWaypoints;
            int iconsOnWorldMap = 0;
            int maxIconsOnWorldMap = CommonModConfig.config.worldmap.maxMarkerIconWaypoints;
            boolean enableMarkerIcons = CommonModConfig.config.general.enableMarkerIcons;
            Vec3 cameraPos = this.mc.f_91075_.m_20182_();
            markerPositions.sort(Comparator.comparing(p -> cameraPos.m_82531_(p.pos.x, p.pos.y, p.pos.z)));
            for (Position markerPosition : markerPositions) {
                WaypointState waypointState = idToWaypointState.get(markerPosition.id);
                double d = cameraPos.m_82554_(new Vec3(markerPosition.pos.x, markerPosition.pos.y, markerPosition.pos.z));
                waypointState.renderOnHud = CommonModConfig.config.hud.showMarkerWaypoints != ModConfig.ConditionalActiveMode.NEVER && onHud < maxOnHud && d >= (double)minHudD && d <= (double)maxHudD;
                waypointState.renderOnMiniMap = CommonModConfig.config.minimap.showMarkerWaypoints != ModConfig.ConditionalActiveMode.NEVER && onMiniMap < maxOnMiniMap && d >= (double)minMiniD && d <= (double)maxMiniD;
                boolean bl = waypointState.renderOnWorldMap = CommonModConfig.config.worldmap.showMarkerWaypoints != ModConfig.ConditionalActiveMode.NEVER && onWorldMap < maxOnWorldMap && d >= (double)minWorldD && d <= (double)maxWorldD;
                if (waypointState.renderOnHud) {
                    ++onHud;
                }
                if (waypointState.renderOnMiniMap) {
                    ++onMiniMap;
                }
                if (waypointState.renderOnWorldMap) {
                    ++onWorldMap;
                }
                if (!waypointState.renderOnHud && !waypointState.renderOnMiniMap && !waypointState.renderOnWorldMap) continue;
                if (enableMarkerIcons && waypointState.hasIcon && serverEntry.includeIconMarkerLayer(markerPosition.layer.id) && serverEntry.includeIcon(markerPosition.name)) {
                    waypointState.renderIconOnHud = iconsOnHud < maxIconsOnHud && d >= (double)minIconHudD && d <= (double)maxIconHudD;
                    waypointState.renderIconOnMiniMap = iconsOnMiniMap < maxIconsOnMiniMap && d >= (double)minIconMiniD && d <= (double)maxIconMiniD;
                    boolean bl2 = waypointState.renderIconOnWorldMap = iconsOnWorldMap < maxIconsOnWorldMap && d >= (double)minIconWorldD && d <= (double)maxIconWorldD;
                    if (waypointState.renderIconOnHud) {
                        ++iconsOnHud;
                    }
                    if (waypointState.renderIconOnMiniMap) {
                        ++iconsOnMiniMap;
                    }
                    if (waypointState.renderIconOnWorldMap) {
                        ++iconsOnWorldMap;
                    }
                } else {
                    waypointState.renderIconOnHud = false;
                    waypointState.renderIconOnMiniMap = false;
                    waypointState.renderIconOnWorldMap = false;
                }
                this.currentMarkerIds.add(markerPosition.id);
                this.addOrUpdateMarkerWaypoint(markerPosition, waypointState);
            }
            this.removeOldMarkerWaypoints();
            int newMarkerWaypointColor = CommonModConfig.config.general.markerWaypointColor.ordinal();
            if (this.previousMarkerWaypointColor != newMarkerWaypointColor) {
                this.previousMarkerWaypointColor = newMarkerWaypointColor;
                this.updateMarkerWaypointColors();
            }
            if (!(this.markerMessageWasShown || onHud <= 25 && onMiniMap <= 25 || CommonModConfig.config.general.ignoreMarkerMessage)) {
                this.markerMessageWasShown = true;
                Utils.sendToClientChat((Component)Text.literal("[Map Link]: Looks like you have quite a lot of markers from the server visible! Did you know that you can chose the marker layers that are shown in the config, decrease their maximum distance, set a limit on how many are displayed or disable marker waypoints entirely? (The default config already limits the amount to 40) ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)).m_7220_((Component)Text.literal("[Don't show this again]").m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/maplink ignore_marker_message")).m_131140_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true)))));
            }
        } else {
            this.removeAllMarkerWaypoints();
        }
    }

    abstract void addOrUpdateMarkerWaypoint(Position var1, WaypointState var2);

    abstract void removeOldMarkerWaypoints();

    public abstract void removeAllMarkerWaypoints();

    abstract void updateMarkerWaypointColors();

    public abstract void handleAreaMarkers(List<AreaMarker> var1);

    public abstract void removeAllAreaMarkers(boolean var1);
}

