/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common.waypoints;

import de.the_build_craft.maplink.common.waypoints.Double3;
import de.the_build_craft.maplink.common.waypoints.MarkerLayer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class Position {
    private static final Pattern nameRegexPattern = Pattern.compile("<.+?>|\\R|\\n");
    public final String name;
    public final Double3 pos;
    public final String id;
    public final MarkerLayer layer;

    public Position(String name, int x, int y, int z, String id, MarkerLayer layer) {
        this.name = Position.getDisplayName(name);
        this.pos = new Double3((float)x + 0.5f, y, (float)z + 0.5f);
        this.id = "maplink_" + id;
        this.layer = layer;
    }

    public Position(String name, double x, double y, double z, String id, MarkerLayer layer) {
        this.name = Position.getDisplayName(name);
        this.pos = new Double3(x, y, z);
        this.id = "maplink_" + id;
        this.layer = layer;
    }

    static String getDisplayName(String name) {
        return StringEscapeUtils.unescapeHtml4((String)nameRegexPattern.matcher(name).replaceAll("").trim());
    }
}

