/*
 *    This file is part of the Map Link mod
 *    licensed under the GNU GPL v3 License.
 *
 *    Copyright (C) 2024 - 2025  Leander Knüttel and contributors
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package de.the_build_craft.maplink.mixins.common.client;

import de.the_build_craft.maplink.common.AbstractModInitializer;
import de.the_build_craft.maplink.common.wrappers.Text;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_355;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_640;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static de.the_build_craft.maplink.common.CommonModConfig.*;

/**
 * @author Leander Knüttel
 * @author MeerBiene
 * @version 30.08.2025
 */
@Mixin(class_355.class)
public class PlayerListHudMixin {

    @Unique
    private static String maplink$getFormatedDuration(String playerName) {
        long durationInMs = System.currentTimeMillis() - AbstractModInitializer.lastPlayerActivityTimeMap.get(playerName);
        int durationInMin = (int)(durationInMs / 60_000);
        int hours = (int) Math.floor(durationInMin / 60.0);
        int minutes = durationInMin % 60;

        if (hours == 0) {
            return minutes + " min";
        }
        if (config.general.hideAfkMinutes) {
            return hours + " h";
        }
        return hours + " h  " + minutes + " min";
    }

    @Inject(method = "getNameForDisplay", at = @At("RETURN"), cancellable = true)
    private void injected(class_640 entry, CallbackInfoReturnable<class_2561> cir) {
        if (!(config.general.enabled
                && AbstractModInitializer.connected
                && config.general.showAfkInTabList)) {
            return;
        }

        String playerName = entry.method_2966().getName();
        class_5250 newText = cir.getReturnValue().method_27661();

        if (AbstractModInitializer.AfkMap.containsKey(playerName)) {
            if (AbstractModInitializer.AfkMap.get(playerName)) {
                if (config.general.showAfkTimeInTabList) {
                    cir.setReturnValue(newText.method_10852(Text.literal("  [AFK: "
                                    + (AbstractModInitializer.playerOverAfkTimeMap.get(playerName) ? "> " : "")
                                    + maplink$getFormatedDuration(playerName) + "]")
                            .method_10862(class_2583.field_24360.method_27703(class_5251.method_27717(config.general.AfkColor)))));
                }
                else {
                    cir.setReturnValue(newText.method_10852(Text.literal("  [AFK]")
                            .method_10862(class_2583.field_24360.method_27703(class_5251.method_27717(config.general.AfkColor)))));
                }
            }
        } else {
            cir.setReturnValue(newText.method_10852(Text.literal("  [???]")
                    .method_10862(class_2583.field_24360.method_27703(class_5251.method_27717(config.general.unknownAfkStateColor)))));
        }
    }
}
