/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common.waypoints;

import de.the_build_craft.maplink.common.waypoints.Int3;

public class Double3 {
    public static final Double3 ZERO = new Double3(0.0, 0.0, 0.0);
    public final double x;
    public final double y;
    public final double z;

    public Double3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public String toString() {
        return this.x + " " + this.y + " " + this.z;
    }

    public boolean roughlyEqual(Double3 double3) {
        double e = 0.01;
        return Math.abs(this.x - double3.x) < 0.01 && Math.abs(this.y - double3.y) < 0.01 && Math.abs(this.z - double3.z) < 0.01;
    }

    public Int3 roundToInt3() {
        return new Int3((int)Math.round(this.x), (int)Math.round(this.y), (int)Math.round(this.z));
    }

    public Int3 floorToInt3() {
        return new Int3((int)Math.floor(this.x), (int)Math.floor(this.y), (int)Math.floor(this.z));
    }

    public Int3 ceilToInt3() {
        return new Int3((int)Math.ceil(this.x), (int)Math.ceil(this.y), (int)Math.ceil(this.z));
    }

    public Double3 add(Double3 double3) {
        return new Double3(this.x + double3.x, this.y + double3.y, this.z + double3.z);
    }

    public Double3 sub(Double3 double3) {
        return new Double3(this.x - double3.x, this.y - double3.y, this.z - double3.z);
    }

    public double dot(Double3 double3) {
        return this.x * double3.x + this.y * double3.y + this.z * double3.z;
    }

    public double len() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }
}

