/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common;

import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.wrappers.Text;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

@Config(name="maplink")
public class ModConfig
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="general")
    @ConfigEntry.Gui.TransitiveObject
    public General general = new General();
    @ConfigEntry.Category(value="friends")
    @ConfigEntry.Gui.TransitiveObject
    public Friends friends = new Friends();
    @ConfigEntry.Category(value="hud")
    @ConfigEntry.Gui.TransitiveObject
    public HudModule hud = new HudModule();
    @ConfigEntry.Category(value="minimap")
    @ConfigEntry.Gui.TransitiveObject
    public MiniMapModule minimap = new MiniMapModule();
    @ConfigEntry.Category(value="worldmap")
    @ConfigEntry.Gui.TransitiveObject
    public WorldMapModule worldmap = new WorldMapModule();

    @Config(name="general")
    public static class General
    implements ConfigData {
        public boolean enabled = true;
        @ConfigEntry.Gui.Tooltip
        public List<ServerEntry> serverEntries = new ArrayList<ServerEntry>();
        @ConfigEntry.Gui.Tooltip
        public int maxUpdateDelay = 2000;
        @ConfigEntry.Gui.Tooltip
        public int defaultY = 64;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public ConditionalActiveMode minimapWaypointsRenderBelow = ConditionalActiveMode.WHEN_PLAYER_LIST_SHOWN;
        @ConfigEntry.Gui.PrefixText
        public boolean enablePlayerWaypoints = true;
        @ConfigEntry.Gui.Tooltip
        public boolean showPlayerWaypointsAsTrackedPlayers = true;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int interpolationTime = 100;
        @ConfigEntry.Gui.Tooltip
        public boolean enablePlayerIconWaypoints = true;
        @ConfigEntry.Gui.Tooltip
        public boolean useMcHeadsPlayerNameIcons = false;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public WaypointColor playerWaypointColor = WaypointColor.Black;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        public boolean showAfkInTabList = true;
        @ConfigEntry.Gui.Tooltip
        public int timeUntilAfk = 120;
        @ConfigEntry.Gui.Tooltip
        public boolean showAfkTimeInTabList = true;
        public boolean hideAfkMinutes = false;
        @ConfigEntry.ColorPicker
        public int AfkColor = 0xFF5500;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.ColorPicker
        public int unknownAfkStateColor = 0x606060;
        @ConfigEntry.Gui.PrefixText
        public boolean enableMarkerWaypoints = true;
        public boolean enableMarkerIcons = true;
        @ConfigEntry.Gui.Tooltip
        public boolean showDefaultMarkerIcons = true;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public WaypointColor markerWaypointColor = WaypointColor.Gray;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        public boolean enableAreaMarkerOverlay = true;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=200L)
        public int areaFillAlphaMul = 100;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int areaFillAlphaMin = 0;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int areaFillAlphaMax = 42;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=200L)
        public int areaLineAlphaMul = 100;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int areaLineAlphaMin = 0;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        public int areaLineAlphaMax = 100;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=1L, max=256L)
        public int blocksPerChunkThreshold = 128;
        @ConfigEntry.Gui.Tooltip
        public int maxChunkArea = 500000;
        @ConfigEntry.Gui.PrefixText
        public List<String> ignoredServers = new ArrayList<String>();
        public boolean ignoreMarkerMessage = false;
        public boolean hideAllChatErrors = false;
        @ConfigEntry.Gui.PrefixText
        public boolean debugMode = false;
        public boolean chatLogInDebugMode = false;
        @ConfigEntry.Gui.Excluded
        public boolean ignoreCertificatesUseAtYourOwnRisk = false;
        @ConfigEntry.Gui.Excluded
        public int configVersionDoNotEdit = 2;
    }

    @Config(name="friends")
    public static class Friends
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip
        public List<String> friendList = new ArrayList<String>();
        public boolean onlyShowFriendsWaypoints = false;
        public boolean onlyShowFriendsIconWaypoints = false;
        @ConfigEntry.Gui.Tooltip
        public boolean alwaysShowFriendsWaypoints = true;
        @ConfigEntry.Gui.Tooltip
        public boolean alwaysShowFriendsIconWaypoints = true;
        public boolean overwriteFriendWaypointColor = false;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public WaypointColor friendWaypointColor = WaypointColor.Black;
    }

    @Config(name="hud")
    public static class HudModule
    implements ConfigData {
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public ConditionalActiveMode showPlayerWaypoints = ConditionalActiveMode.ALWAYS;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public ConditionalActiveMode showMarkerWaypoints = ConditionalActiveMode.ALWAYS;
        public boolean hidePlayersInRange = false;
        public boolean hidePlayersVisible = false;
        public boolean showTrackerDistance = true;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=10L, max=200L)
        public int playerTextScale = 100;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=10L, max=200L)
        public int playerIconScale = 100;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=10L, max=200L)
        public int markerTextScale = 100;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=10L, max=200L)
        public int markerIconScale = 100;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        public int minVisiblePlayerDistance = 30;
        @ConfigEntry.Gui.Tooltip
        public int minNotVisiblePlayerDistance = 10;
        @ConfigEntry.Gui.Tooltip
        public int maxPlayerDistance = 100000;
        @ConfigEntry.Gui.Tooltip
        public int maxPlayerWaypoints = 40;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        public int minPlayerIconDistance = 0;
        @ConfigEntry.Gui.Tooltip
        public int maxPlayerIconDistance = 100000;
        @ConfigEntry.Gui.Tooltip
        public int maxPlayerIconWaypoints = 40;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        public int minMarkerDistance = 0;
        @ConfigEntry.Gui.Tooltip
        public int maxMarkerDistance = 100000;
        @ConfigEntry.Gui.Tooltip
        public int maxMarkerWaypoints = 40;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        public int minMarkerIconDistance = 0;
        @ConfigEntry.Gui.Tooltip
        public int maxMarkerIconDistance = 100000;
        @ConfigEntry.Gui.Tooltip
        public int maxMarkerIconWaypoints = 40;
    }

    @Config(name="minimap")
    public static class MiniMapModule
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public ConditionalActiveMode showPlayerWaypoints = ConditionalActiveMode.ALWAYS;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public ConditionalActiveMode showMarkerWaypoints = ConditionalActiveMode.ALWAYS;
        @ConfigEntry.Gui.Tooltip
        public boolean hidePlayersInRange = false;
        @ConfigEntry.Gui.Tooltip
        public boolean outOfBoundsPlayerWaypoints = true;
        @ConfigEntry.Gui.Tooltip
        public boolean outOfBoundsMarkerWaypoints = true;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=10L, max=200L)
        public int playerTextScale = 100;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=10L, max=200L)
        public int playerIconScale = 100;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=10L, max=200L)
        public int markerTextScale = 100;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=10L, max=200L)
        public int markerIconScale = 100;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        public int minPlayerDistance = 0;
        @ConfigEntry.Gui.Tooltip
        public int maxPlayerDistance = 100000;
        @ConfigEntry.Gui.Tooltip
        public int maxPlayerWaypoints = 40;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        public int minPlayerIconDistance = 0;
        @ConfigEntry.Gui.Tooltip
        public int maxPlayerIconDistance = 100000;
        @ConfigEntry.Gui.Tooltip
        public int maxPlayerIconWaypoints = 40;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        public int minMarkerDistance = 0;
        @ConfigEntry.Gui.Tooltip
        public int maxMarkerDistance = 100000;
        @ConfigEntry.Gui.Tooltip
        public int maxMarkerWaypoints = 40;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        public int minMarkerIconDistance = 0;
        @ConfigEntry.Gui.Tooltip
        public int maxMarkerIconDistance = 100000;
        @ConfigEntry.Gui.Tooltip
        public int maxMarkerIconWaypoints = 40;
    }

    @Config(name="worldmap")
    public static class WorldMapModule
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public ConditionalActiveMode showPlayerWaypoints = ConditionalActiveMode.ALWAYS;
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public ConditionalActiveMode showMarkerWaypoints = ConditionalActiveMode.ALWAYS;
        @ConfigEntry.Gui.Tooltip
        public boolean hidePlayersInRange = false;
        public boolean waypointIconBackground = false;
        public boolean showTrackerDistance = true;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=10L, max=200L)
        public int playerTextScale = 100;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=10L, max=200L)
        public int playerIconScale = 100;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=10L, max=200L)
        public int markerTextScale = 100;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=10L, max=200L)
        public int markerIconScale = 100;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        public int minPlayerDistance = 0;
        @ConfigEntry.Gui.Tooltip
        public int maxPlayerDistance = 1000000;
        @ConfigEntry.Gui.Tooltip
        public int maxPlayerWaypoints = 1000;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        public int minPlayerIconDistance = 0;
        @ConfigEntry.Gui.Tooltip
        public int maxPlayerIconDistance = 1000000;
        @ConfigEntry.Gui.Tooltip
        public int maxPlayerIconWaypoints = 1000;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        public int minMarkerDistance = 0;
        @ConfigEntry.Gui.Tooltip
        public int maxMarkerDistance = 1000000;
        @ConfigEntry.Gui.Tooltip
        public int maxMarkerWaypoints = 10000;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        public int minMarkerIconDistance = 0;
        @ConfigEntry.Gui.Tooltip
        public int maxMarkerIconDistance = 1000000;
        @ConfigEntry.Gui.Tooltip
        public int maxMarkerIconWaypoints = 10000;
    }

    public static enum ConditionalActiveMode {
        NEVER,
        ALWAYS,
        WHEN_PLAYER_LIST_SHOWN,
        WHEN_PLAYER_LIST_HIDDEN;


        public boolean isActive() {
            boolean playerListShown = Minecraft.getInstance().options.keyPlayerList.isDown();
            switch (this.ordinal()) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return playerListShown;
                }
                case 3: {
                    return !playerListShown;
                }
            }
            return false;
        }

        public String toString() {
            return this.toText().getString();
        }

        public Component toText() {
            return Text.translatable("maplink.ConditionalActiveMode." + this.name());
        }
    }

    public static enum WaypointColor {
        Black,
        DarkBlue,
        DarkGreen,
        DarkAqua,
        DarkRed,
        DarkPurple,
        Gold,
        Gray,
        DarkGray,
        Blue,
        Green,
        Aqua,
        Red,
        LightPurple,
        Yellow,
        White;


        public String toString() {
            return this.toText().getString();
        }

        public Component toText() {
            return Text.translatable("maplink.WaypointColor." + this.name()).setStyle(Style.EMPTY.withColor(ChatFormatting.values()[this.ordinal()]));
        }
    }

    public static class ServerEntry {
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public MapType maptype;
        public String ip;
        public String link;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public MarkerVisibilityMode markerVisibilityMode;
        @ConfigEntry.Gui.Tooltip
        public List<String> markerLayers;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public SimpleMarkerVisibilityMode individualMarkerMode;
        @ConfigEntry.Gui.Tooltip
        public List<String> markers;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public MarkerVisibilityMode areaMarkerVisibilityMode;
        @ConfigEntry.Gui.Tooltip
        public List<String> areaMarkerLayers;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public SimpleMarkerVisibilityMode individualAreaMarkerMode;
        @ConfigEntry.Gui.Tooltip
        public List<String> areaMarkers;
        @ConfigEntry.Gui.PrefixText
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public MarkerVisibilityMode iconMarkerVisibilityMode;
        @ConfigEntry.Gui.Tooltip
        public List<String> iconMarkerLayers;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public SimpleMarkerVisibilityMode individualIconMode;
        @ConfigEntry.Gui.Tooltip
        public List<String> icons;

        public ServerEntry() {
            this("", "", MapType.Bluemap, MarkerVisibilityMode.Auto, new ArrayList<String>(), SimpleMarkerVisibilityMode.BlackList, new ArrayList<String>(), MarkerVisibilityMode.Auto, new ArrayList<String>(), SimpleMarkerVisibilityMode.BlackList, new ArrayList<String>(), MarkerVisibilityMode.Auto, new ArrayList<String>(), SimpleMarkerVisibilityMode.BlackList, new ArrayList<String>());
        }

        public ServerEntry(String ip, String link, MapType maptype, MarkerVisibilityMode markerVisibilityMode, List<String> markerLayers, SimpleMarkerVisibilityMode individualMarkerMode, List<String> markers, MarkerVisibilityMode areaMarkerVisibilityMode, List<String> areaMarkerLayers, SimpleMarkerVisibilityMode individualAreaMarkerMode, List<String> areaMarkers, MarkerVisibilityMode iconMarkerVisibilityMode, List<String> iconMarkerLayers, SimpleMarkerVisibilityMode individualIconMode, List<String> icons) {
            this.ip = ip;
            this.link = link;
            this.maptype = maptype;
            this.markerVisibilityMode = markerVisibilityMode;
            this.markerLayers = markerLayers;
            this.individualMarkerMode = individualMarkerMode;
            this.markers = markers;
            this.areaMarkerVisibilityMode = areaMarkerVisibilityMode;
            this.areaMarkerLayers = areaMarkerLayers;
            this.individualAreaMarkerMode = individualAreaMarkerMode;
            this.areaMarkers = areaMarkers;
            this.iconMarkerVisibilityMode = iconMarkerVisibilityMode;
            this.iconMarkerLayers = iconMarkerLayers;
            this.individualIconMode = individualIconMode;
            this.icons = icons;
        }

        public void setMarkerLayers(List<String> layers) {
            if (this.markerVisibilityMode == MarkerVisibilityMode.Auto) {
                this.markerLayers = layers;
                this.markerVisibilityMode = MarkerVisibilityMode.All;
            }
            if (this.areaMarkerVisibilityMode == MarkerVisibilityMode.Auto) {
                this.areaMarkerLayers = layers;
                this.areaMarkerVisibilityMode = MarkerVisibilityMode.All;
            }
            if (this.iconMarkerVisibilityMode == MarkerVisibilityMode.Auto) {
                this.iconMarkerLayers = layers;
                this.iconMarkerVisibilityMode = MarkerVisibilityMode.All;
            }
            CommonModConfig.saveConfig();
        }

        public boolean needsMarkerLayerUpdate() {
            return this.markerVisibilityMode == MarkerVisibilityMode.Auto || this.areaMarkerVisibilityMode == MarkerVisibilityMode.Auto || this.iconMarkerVisibilityMode == MarkerVisibilityMode.Auto;
        }

        public boolean includeMarkerLayer(String layer) {
            return this.includeLayer(this.markerVisibilityMode, this.markerLayers, layer);
        }

        public boolean includeAreaMarkerLayer(String layer) {
            return this.includeLayer(this.areaMarkerVisibilityMode, this.areaMarkerLayers, layer);
        }

        public boolean includeIconMarkerLayer(String layer) {
            return this.includeLayer(this.iconMarkerVisibilityMode, this.iconMarkerLayers, layer);
        }

        private boolean includeLayer(MarkerVisibilityMode markerVisibilityMode, List<String> layers, String layer) {
            switch (markerVisibilityMode.ordinal()) {
                case 0: 
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case 3: {
                    return !layers.contains(layer);
                }
                case 4: {
                    return layers.contains(layer);
                }
            }
            throw new IllegalArgumentException();
        }

        public boolean includeMarker(String name) {
            return this.include(this.individualMarkerMode, this.markers, name);
        }

        public boolean includeAreaMarker(String name) {
            return this.include(this.individualAreaMarkerMode, this.areaMarkers, name);
        }

        public boolean includeIcon(String name) {
            return this.include(this.individualIconMode, this.icons, name);
        }

        private boolean include(SimpleMarkerVisibilityMode visibilityMode, List<String> words, String name) {
            if (visibilityMode == SimpleMarkerVisibilityMode.BlackList) {
                for (String word : words) {
                    if (!name.contains(word)) continue;
                    return false;
                }
                return true;
            }
            for (String word : words) {
                if (!name.contains(word)) continue;
                return true;
            }
            return false;
        }

        public int getMarkerVisibilityHash() {
            return Objects.hash(new Object[]{CommonModConfig.config.general.enableMarkerWaypoints, this.markerVisibilityMode, this.markerLayers, this.individualMarkerMode, this.markers});
        }

        public int getAreaMarkerVisibilityHash() {
            return Objects.hash(new Object[]{CommonModConfig.config.general.enableAreaMarkerOverlay, this.areaMarkerVisibilityMode, this.areaMarkerLayers, CommonModConfig.config.general.blocksPerChunkThreshold, CommonModConfig.config.general.areaFillAlphaMul, CommonModConfig.config.general.areaFillAlphaMin, CommonModConfig.config.general.areaFillAlphaMax, CommonModConfig.config.general.areaLineAlphaMul, CommonModConfig.config.general.areaLineAlphaMin, CommonModConfig.config.general.areaLineAlphaMax, CommonModConfig.config.general.maxChunkArea, this.individualAreaMarkerMode, this.areaMarkers});
        }

        public static enum MapType {
            Bluemap,
            Dynmap,
            LiveAtlas,
            Pl3xMap,
            Squaremap;

        }

        public static enum MarkerVisibilityMode {
            Auto(false),
            All(false),
            None(false),
            BlackList(true),
            WhiteList(true);

            public final boolean allowsEdit;

            private MarkerVisibilityMode(boolean allowsEdit) {
                this.allowsEdit = allowsEdit;
            }
        }

        public static enum SimpleMarkerVisibilityMode {
            BlackList,
            WhiteList;

        }
    }
}

