/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common.connections;

import de.the_build_craft.maplink.common.AbstractModInitializer;
import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.ModConfig;
import de.the_build_craft.maplink.common.waypoints.PlayerPosition;
import de.the_build_craft.maplink.common.wrappers.Text;
import de.the_build_craft.maplink.common.wrappers.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public abstract class MapConnection {
    public URL queryURL;
    public final Minecraft mc = Minecraft.getInstance();
    public String currentDimension = "";
    public String onlineMapConfigLink;
    public boolean foundPlayer;
    public boolean partOfLiveAtlas;
    private boolean firstPlayerUpdate = true;

    public void setCurrentDimension(String currentDimension) {
        this.currentDimension = currentDimension;
    }

    @NotNull
    protected String getBaseURL(ModConfig.ServerEntry serverEntry, boolean useHttps) {
        int i;
        Object baseURL = serverEntry.link;
        if (!((String)baseURL).startsWith(useHttps ? "https://" : "http://")) {
            baseURL = (useHttps ? "https://" : "http://") + (String)baseURL;
        }
        if ((i = ((String)baseURL).indexOf("?")) != -1) {
            baseURL = ((String)baseURL).substring(0, i - 1);
        }
        if ((i = ((String)baseURL).indexOf("#")) != -1) {
            baseURL = ((String)baseURL).substring(0, i - 1);
        }
        if (((String)baseURL).endsWith("index.html")) {
            baseURL = ((String)baseURL).substring(0, ((String)baseURL).length() - 10);
        }
        if (((String)baseURL).endsWith("/")) {
            baseURL = ((String)baseURL).substring(0, ((String)baseURL).length() - 1);
        }
        return ((String)baseURL).replace(" ", "%20");
    }

    public abstract HashMap<String, PlayerPosition> getPlayerPositions() throws IOException;

    public HashMap<String, PlayerPosition> HandlePlayerPositions(PlayerPosition[] playerPositions) {
        HashMap<String, PlayerPosition> newPlayerPositions = new HashMap<String, PlayerPosition>();
        if (this.mc.player == null) {
            return newPlayerPositions;
        }
        String clientName = this.mc.player.getName().getString();
        this.foundPlayer = false;
        if (!AbstractModInitializer.overwriteCurrentDimension) {
            this.currentDimension = "";
            for (PlayerPosition playerPosition : playerPositions) {
                if (!Objects.equals(playerPosition.name, clientName)) continue;
                this.currentDimension = playerPosition.world;
                this.foundPlayer = true;
                break;
            }
        }
        if (this.currentDimension.equals("-some-other-bogus-world-")) {
            this.currentDimension = "";
        }
        if (CommonModConfig.config.general.debugMode && CommonModConfig.config.general.chatLogInDebugMode) {
            Utils.sendToClientChat("---");
        }
        if (!this.firstPlayerUpdate) {
            for (Map.Entry entry : AbstractModInitializer.lastPlayerUpdateTimeMap.entrySet()) {
                if ((System.currentTimeMillis() - (Long)entry.getValue()) / 1000L < (long)(Math.max(30, CommonModConfig.config.general.timeUntilAfk) - 5)) continue;
                String playerName = (String)entry.getKey();
                AbstractModInitializer.lastPlayerPosMap.remove(playerName);
                AbstractModInitializer.playerOverAfkTimeMap.remove(playerName);
                AbstractModInitializer.AfkMap.remove(playerName);
            }
        }
        for (PlayerPosition playerPosition : playerPositions) {
            this.UpdateAfkInfo(playerPosition, clientName);
            if (!CommonModConfig.config.general.debugMode && (!Objects.equals(playerPosition.world, this.currentDimension) || Objects.equals(playerPosition.name, clientName))) continue;
            newPlayerPositions.put(playerPosition.name, playerPosition);
        }
        this.firstPlayerUpdate = false;
        return newPlayerPositions;
    }

    public void UpdateAfkInfo(PlayerPosition playerPosition, String clientName) {
        AbstractModInitializer.lastPlayerUpdateTimeMap.put(playerPosition.name, System.currentTimeMillis());
        if (AbstractModInitializer.lastPlayerPosMap.containsKey(playerPosition.name)) {
            if (AbstractModInitializer.lastPlayerPosMap.get(playerPosition.name).roughlyEqual(playerPosition.pos)) {
                if (CommonModConfig.config.general.debugMode && CommonModConfig.config.general.chatLogInDebugMode) {
                    Utils.sendToClientChat(playerPosition.name + "  afk_time: " + (System.currentTimeMillis() - AbstractModInitializer.lastPlayerActivityTimeMap.get(playerPosition.name)) / 1000L);
                }
                if ((System.currentTimeMillis() - AbstractModInitializer.lastPlayerActivityTimeMap.get(playerPosition.name)) / 1000L >= (long)Math.max(30, CommonModConfig.config.general.timeUntilAfk)) {
                    AbstractModInitializer.AfkMap.put(playerPosition.name, true);
                }
            } else {
                AbstractModInitializer.AfkMap.put(playerPosition.name, false);
                AbstractModInitializer.lastPlayerActivityTimeMap.put(playerPosition.name, System.currentTimeMillis());
                AbstractModInitializer.lastPlayerPosMap.put(playerPosition.name, playerPosition.pos);
                AbstractModInitializer.playerOverAfkTimeMap.put(playerPosition.name, false);
            }
        } else {
            AbstractModInitializer.lastPlayerActivityTimeMap.put(playerPosition.name, System.currentTimeMillis());
            AbstractModInitializer.lastPlayerPosMap.put(playerPosition.name, playerPosition.pos);
            if (this.firstPlayerUpdate) {
                AbstractModInitializer.playerOverAfkTimeMap.put(playerPosition.name, !playerPosition.name.equals(clientName));
            } else {
                AbstractModInitializer.playerOverAfkTimeMap.put(playerPosition.name, false);
                AbstractModInitializer.AfkMap.put(playerPosition.name, false);
            }
        }
    }

    public abstract void getWaypointPositions(boolean var1) throws IOException;

    public void OpenOnlineMapConfig() {
        Utils.sendToClientChat((Component)Text.literal(this.onlineMapConfigLink).withStyle(Style.EMPTY.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(this.onlineMapConfigLink)))));
    }

    public abstract Set<String> getMarkerLayers();
}

