/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.mixins.common.client;

import de.the_build_craft.maplink.common.AbstractModInitializer;
import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.wrappers.Text;
import net.minecraft.client.gui.components.PlayerTabOverlay;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerTabOverlay.class})
public class PlayerListHudMixin {
    @Unique
    private static String maplink$getFormatedDuration(String playerName) {
        long durationInMs = System.currentTimeMillis() - AbstractModInitializer.lastPlayerActivityTimeMap.get(playerName);
        int durationInMin = (int)(durationInMs / 60000L);
        int hours = (int)Math.floor((double)durationInMin / 60.0);
        int minutes = durationInMin % 60;
        if (hours == 0) {
            return minutes + " min";
        }
        if (CommonModConfig.config.general.hideAfkMinutes) {
            return hours + " h";
        }
        return hours + " h  " + minutes + " min";
    }

    @Inject(method={"getNameForDisplay(Lnet/minecraft/client/multiplayer/PlayerInfo;)Lnet/minecraft/network/chat/Component;"}, at={@At(value="RETURN")}, cancellable=true)
    private void injected(PlayerInfo entry, CallbackInfoReturnable<Component> cir) {
        if (!(CommonModConfig.config.general.enabled && AbstractModInitializer.connected && CommonModConfig.config.general.showAfkInTabList)) {
            return;
        }
        String playerName = entry.getProfile().getName();
        MutableComponent newText = ((Component)cir.getReturnValue()).copy();
        if (AbstractModInitializer.AfkMap.containsKey(playerName)) {
            if (AbstractModInitializer.AfkMap.get(playerName).booleanValue()) {
                if (CommonModConfig.config.general.showAfkTimeInTabList) {
                    cir.setReturnValue((Object)newText.append((Component)Text.literal(" [AFK: " + (AbstractModInitializer.playerOverAfkTimeMap.get(playerName) != false ? "> " : "") + PlayerListHudMixin.maplink$getFormatedDuration(playerName) + "]").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)CommonModConfig.config.general.AfkColor)))));
                } else {
                    cir.setReturnValue((Object)newText.append((Component)Text.literal(" [AFK]").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)CommonModConfig.config.general.AfkColor)))));
                }
            }
        } else {
            cir.setReturnValue((Object)newText.append((Component)Text.literal(" [???]").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)CommonModConfig.config.general.unknownAfkStateColor)))));
        }
    }
}

