/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common.connections;

import com.google.common.reflect.TypeToken;
import de.the_build_craft.maplink.common.AbstractModInitializer;
import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.HTTP;
import de.the_build_craft.maplink.common.ModConfig;
import de.the_build_craft.maplink.common.UpdateTask;
import de.the_build_craft.maplink.common.clientMapHandlers.ClientMapHandler;
import de.the_build_craft.maplink.common.configurations.Pl3xMapConfiguration;
import de.the_build_craft.maplink.common.connections.MapConnection;
import de.the_build_craft.maplink.common.mapUpdates.Pl3xMapMarkerLayerConfig;
import de.the_build_craft.maplink.common.mapUpdates.Pl3xMapMarkerUpdate;
import de.the_build_craft.maplink.common.mapUpdates.Pl3xMapPlayerUpdate;
import de.the_build_craft.maplink.common.mapUpdates.SquareMapMarkerUpdate;
import de.the_build_craft.maplink.common.waypoints.AreaMarker;
import de.the_build_craft.maplink.common.waypoints.Color;
import de.the_build_craft.maplink.common.waypoints.Double3;
import de.the_build_craft.maplink.common.waypoints.Int3;
import de.the_build_craft.maplink.common.waypoints.MarkerLayer;
import de.the_build_craft.maplink.common.waypoints.PlayerPosition;
import de.the_build_craft.maplink.common.waypoints.Position;
import de.the_build_craft.maplink.common.wrappers.Utils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Pl3xMapConnection
extends MapConnection {
    private String markerLayerStringTemplate = "";
    private String markerStringTemplate = "";
    private String markerIconLinkTemplate = "";
    int version;
    private String lastMarkerDimension = "";
    int lastMarkerHash;
    int lastAreaMarkerHash;
    List<Position> positions = new ArrayList<Position>();
    List<AreaMarker> areaMarkers = new ArrayList<AreaMarker>();
    private final Map<String, Function<Pl3xMapMarkerUpdate, Int3[][]>> areaTypes = new HashMap<String, Function<Pl3xMapMarkerUpdate, Int3[][]>>();

    public Pl3xMapConnection(ModConfig.ServerEntry serverEntry, UpdateTask updateTask) throws IOException {
        this.areaTypes.put("circ", m -> new Int3[][]{this.convertCircleToPolygon(m.data.center, m.data.radius)});
        this.areaTypes.put("multipoly", m -> (Int3[][])Arrays.stream(m.data.polygons).flatMap(p -> Arrays.stream(p.polylines)).map(pl -> pl.points).toArray(x$0 -> new Int3[x$0][]));
        this.areaTypes.put("poly", m -> (Int3[][])Arrays.stream(m.data.polylines).map(pl -> pl.points).toArray(x$0 -> new Int3[x$0][]));
        this.areaTypes.put("line", m -> new Int3[][]{m.data.points});
        this.areaTypes.put("rect", m -> new Int3[][]{{m.data.point1, new Int3(m.data.point1.x, 0, m.data.point2.z), m.data.point2, new Int3(m.data.point2.x, 0, m.data.point1.z)}});
        try {
            this.generateLink(serverEntry, true);
        }
        catch (Exception ignored) {
            try {
                this.generateLink(serverEntry, false);
            }
            catch (Exception e) {
                if (!updateTask.linkBrokenErrorWasShown) {
                    updateTask.linkBrokenErrorWasShown = true;
                    Utils.sendErrorToClientChat("[Map Link]: Error: Your Pl3xMap link is broken!");
                }
                throw e;
            }
        }
    }

    public Pl3xMapConnection(String baseURL, String link, boolean partOfLifeAtlas) throws IOException {
        this.areaTypes.put("circ", m -> new Int3[][]{this.convertCircleToPolygon(m.data.center, m.data.radius)});
        this.areaTypes.put("multipoly", m -> (Int3[][])Arrays.stream(m.data.polygons).flatMap(p -> Arrays.stream(p.polylines)).map(pl -> pl.points).toArray(x$0 -> new Int3[x$0][]));
        this.areaTypes.put("poly", m -> (Int3[][])Arrays.stream(m.data.polylines).map(pl -> pl.points).toArray(x$0 -> new Int3[x$0][]));
        this.areaTypes.put("line", m -> new Int3[][]{m.data.points});
        this.areaTypes.put("rect", m -> new Int3[][]{{m.data.point1, new Int3(m.data.point1.x, 0, m.data.point2.z), m.data.point2, new Int3(m.data.point2.x, 0, m.data.point1.z)}});
        this.partOfLiveAtlas = partOfLifeAtlas;
        Matcher matcher = Pattern.compile(".*?//\\w*(\\.\\w+)+(:\\w+)?").matcher((CharSequence)baseURL);
        if (!matcher.find()) {
            throw new RuntimeException("wrong url pattern");
        }
        baseURL = matcher.group();
        if (((String)link).contains("//")) {
            baseURL = link;
        } else {
            if (!((String)link).startsWith("/")) {
                link = "/" + (String)link;
            }
            baseURL = (String)baseURL + (String)link;
        }
        if (((String)baseURL).endsWith("/")) {
            baseURL = ((String)baseURL).substring(0, ((String)baseURL).length() - 1);
        }
        this.setup((String)baseURL);
    }

    private void generateLink(ModConfig.ServerEntry serverEntry, boolean useHttps) throws IOException {
        this.setup(this.getBaseURL(serverEntry, useHttps));
    }

    private void setup(String baseURL) throws IOException {
        this.onlineMapConfigLink = baseURL + "/tiles/settings.json";
        this.markerLayerStringTemplate = baseURL + "/tiles/{world}/markers.json";
        this.markerIconLinkTemplate = baseURL + "/images/icon/registered/{icon}.png";
        if (HTTP.makeTextHttpRequest(URI.create(this.onlineMapConfigLink).toURL()).contains("\"players\":[")) {
            this.version = 0;
            this.queryURL = URI.create(this.onlineMapConfigLink).toURL();
            this.markerStringTemplate = baseURL + "/tiles/{world}/markers/{layerName}.json";
        } else {
            this.version = 1;
            this.queryURL = URI.create(baseURL + "/tiles/players.json").toURL();
        }
        this.getPlayerPositions();
        AbstractModInitializer.LOGGER.info("new link: " + String.valueOf(this.queryURL));
        if (CommonModConfig.config.general.debugMode) {
            Utils.sendToClientChat("new link: " + String.valueOf(this.queryURL));
        }
        this.setUpdateDelay();
    }

    private void setUpdateDelay() {
        try {
            Type apiResponseType = new TypeToken<Pl3xMapMarkerLayerConfig[]>(){}.getType();
            Pl3xMapPlayerUpdate update = HTTP.makeJSONHTTPRequest(this.queryURL, Pl3xMapPlayerUpdate.class);
            float updateDelay = 1.0f;
            for (Pl3xMapPlayerUpdate.WorldSetting ws : update.worldSettings) {
                Pl3xMapMarkerLayerConfig[] mls;
                for (Pl3xMapMarkerLayerConfig ml : mls = (Pl3xMapMarkerLayerConfig[])HTTP.makeJSONHTTPRequest(URI.create(this.markerLayerStringTemplate.replace("{world}", ws.name.replaceAll(":", "-"))).toURL(), apiResponseType)) {
                    if (!Objects.equals(ml.key, "pl3xmap_players")) continue;
                    updateDelay = Math.max(updateDelay, ml.updateInterval);
                }
            }
            UpdateTask.nextUpdateDelay = Math.max(UpdateTask.nextUpdateDelay, (int)Math.ceil(updateDelay * 1000.0f));
        }
        catch (Exception e) {
            AbstractModInitializer.LOGGER.error("Error getting update Delay! Using the Default of 1000 ms for Pl3xMap.", (Throwable)e);
            UpdateTask.nextUpdateDelay = Math.max(UpdateTask.nextUpdateDelay, 1000);
        }
    }

    @Override
    public HashMap<String, PlayerPosition> getPlayerPositions() throws IOException {
        Pl3xMapPlayerUpdate update = HTTP.makeJSONHTTPRequest(this.queryURL, Pl3xMapPlayerUpdate.class);
        PlayerPosition[] positions = new PlayerPosition[update.players.length];
        for (int i = 0; i < update.players.length; ++i) {
            Pl3xMapPlayerUpdate.Player player = update.players[i];
            PlayerPosition playerPosition = null;
            if (this.version == 0) {
                playerPosition = new PlayerPosition(player.name, player.position.x, CommonModConfig.config.general.defaultY, player.position.z, player.world);
            } else if (this.version == 1) {
                playerPosition = new PlayerPosition(player.name, player.x, CommonModConfig.config.general.defaultY, player.z, player.world);
            }
            if (playerPosition == null) continue;
            ClientMapHandler.registerPlayerPosition(playerPosition, "https://mc-heads.net/avatar/" + player.uuid + "/32");
            positions[i] = playerPosition;
        }
        return this.HandlePlayerPositions(positions);
    }

    @Override
    public void getWaypointPositions(boolean forceRefresh) throws IOException {
        if (this.markerLayerStringTemplate.isEmpty() || this.currentDimension.isEmpty()) {
            if (ClientMapHandler.getInstance() != null) {
                ClientMapHandler.getInstance().removeAllMarkerWaypoints();
            }
            return;
        }
        ModConfig.ServerEntry serverEntry = CommonModConfig.getCurrentServerEntry();
        if (serverEntry.needsMarkerLayerUpdate() && !this.partOfLiveAtlas) {
            serverEntry.setMarkerLayers(new ArrayList<String>(this.getMarkerLayers()));
        }
        if (ClientMapHandler.getInstance() == null) {
            return;
        }
        if (this.markerStringTemplate.isEmpty() && this.version == 0) {
            ClientMapHandler.getInstance().removeAllMarkerWaypoints();
            return;
        }
        int newMarkerHash = serverEntry.getMarkerVisibilityHash();
        int newAreaMarkerHash = serverEntry.getAreaMarkerVisibilityHash();
        if (this.lastMarkerDimension.equals(this.currentDimension) && newAreaMarkerHash == this.lastAreaMarkerHash && newMarkerHash == this.lastMarkerHash && !forceRefresh) {
            ClientMapHandler.getInstance().handleMarkerWaypoints(this.positions);
            return;
        }
        this.lastMarkerDimension = this.currentDimension;
        this.lastMarkerHash = newMarkerHash;
        this.lastAreaMarkerHash = newAreaMarkerHash;
        this.positions.clear();
        this.areaMarkers.clear();
        if (this.version == 0) {
            for (MarkerLayer layer : this.getMarkerLayers(false)) {
                Pl3xMapMarkerUpdate[] markers;
                Type apiResponseType = new TypeToken<Pl3xMapMarkerUpdate[]>(){}.getType();
                URL reqUrl = URI.create(this.markerStringTemplate.replace("{world}", this.currentDimension.replaceAll(":", "-")).replace("{layerName}", layer.id)).toURL();
                for (Pl3xMapMarkerUpdate marker : markers = (Pl3xMapMarkerUpdate[])HTTP.makeJSONHTTPRequest(reqUrl, apiResponseType)) {
                    if (Objects.equals(marker.type, "icon") && serverEntry.includeMarkerLayer(layer.id) && serverEntry.includeMarker(marker.options.tooltip.content)) {
                        Position position = new Position(marker.options.tooltip.content, marker.data.point.x, CommonModConfig.config.general.defaultY, marker.data.point.z, this.currentDimension + layer.id + marker.data.key, layer);
                        ClientMapHandler.registerPosition(position, !CommonModConfig.config.general.showDefaultMarkerIcons && marker.data.image.equals("marker-icon") ? null : this.markerIconLinkTemplate.replace("{icon}", marker.data.image));
                        this.positions.add(position);
                    }
                    if (!serverEntry.includeAreaMarkerLayer(layer.id) || !this.areaTypes.containsKey(marker.type) || !serverEntry.includeAreaMarker(marker.options.tooltip.content)) continue;
                    Int3[][] polygons = this.areaTypes.get(marker.type).apply(marker);
                    this.areaMarkers.add(new AreaMarker(marker.options.tooltip.content, 0, 0, 0, polygons, marker.options.stroke != null && marker.options.stroke.enabled ? new Color(marker.options.stroke.color) : new Color(), marker.options.fill != null && marker.options.fill.enabled ? new Color(marker.options.fill.color) : new Color(), this.currentDimension + layer.id + marker.data.key, layer));
                }
            }
        } else if (this.version == 1) {
            SquareMapMarkerUpdate[] markerLayers;
            Type apiResponseType = new TypeToken<SquareMapMarkerUpdate[]>(){}.getType();
            URL reqUrl = URI.create(this.markerLayerStringTemplate.replace("{world}", this.currentDimension.replaceAll(":", "-"))).toURL();
            for (SquareMapMarkerUpdate layer : markerLayers = (SquareMapMarkerUpdate[])HTTP.makeJSONHTTPRequest(reqUrl, apiResponseType)) {
                if (Objects.equals(layer.id, "pl3xmap_players")) continue;
                for (SquareMapMarkerUpdate.Marker marker : layer.markers) {
                    if (Objects.equals(marker.type, "icon") && serverEntry.includeMarkerLayer(layer.id) && serverEntry.includeMarker(marker.tooltip)) {
                        Position position = new Position(marker.tooltip, marker.point.x, CommonModConfig.config.general.defaultY, marker.point.z, this.currentDimension + layer.id + marker.tooltip + marker.point.x + marker.point.z, new MarkerLayer(layer.id, layer.name));
                        ClientMapHandler.registerPosition(position, marker.icon.equals("marker-icon") ? null : this.markerIconLinkTemplate.replace("{icon}", marker.icon));
                        this.positions.add(position);
                        continue;
                    }
                    if (!Objects.equals(marker.type, "polygon") || !serverEntry.includeAreaMarkerLayer(layer.id) || !serverEntry.includeAreaMarker(marker.tooltip)) continue;
                    this.areaMarkers.add(new AreaMarker(marker.tooltip, 0, 0, 0, (Int3[][])Arrays.stream(marker.points).flatMap(Arrays::stream).toArray(x$0 -> new Int3[x$0][]), new Color(marker.color, 1.0f), new Color(marker.fillColor, marker.opacity), this.currentDimension + layer.id + marker.tooltip + Arrays.deepHashCode((Object[])marker.points), new MarkerLayer(layer.id, layer.name)));
                }
            }
        }
        ClientMapHandler.getInstance().handleMarkerWaypoints(this.positions);
        ClientMapHandler.getInstance().handleAreaMarkers(this.areaMarkers);
    }

    Int3[] convertCircleToPolygon(Int3 center, float radius) {
        int N = 40;
        Int3[] points = new Int3[N];
        for (int i = 0; i < N; ++i) {
            double a = Math.PI * 2 / (double)N * (double)i;
            points[i] = new Double3((double)center.x + (double)radius * Math.sin(a), center.y, (double)center.z + (double)radius * Math.cos(a)).roundToInt3();
        }
        return points;
    }

    @Override
    public Set<String> getMarkerLayers() {
        return this.getMarkerLayers(true).stream().map(m -> m.id).collect(Collectors.toSet());
    }

    private Set<MarkerLayer> getMarkerLayers(boolean all) {
        try {
            if (this.version == 0) {
                Type apiResponseType = new TypeToken<Pl3xMapMarkerLayerConfig[]>(){}.getType();
                if (all) {
                    Pl3xMapPlayerUpdate update = HTTP.makeJSONHTTPRequest(this.queryURL, Pl3xMapPlayerUpdate.class);
                    HashSet<MarkerLayer> layerSet = new HashSet<MarkerLayer>();
                    for (Pl3xMapPlayerUpdate.WorldSetting ws : update.worldSettings) {
                        Pl3xMapMarkerLayerConfig[] mls;
                        for (Pl3xMapMarkerLayerConfig ml : mls = (Pl3xMapMarkerLayerConfig[])HTTP.makeJSONHTTPRequest(URI.create(this.markerLayerStringTemplate.replace("{world}", ws.name.replaceAll(":", "-"))).toURL(), apiResponseType)) {
                            if (Objects.equals(ml.key, "pl3xmap_players")) continue;
                            layerSet.add(new MarkerLayer(ml.key, ml.label));
                        }
                    }
                    return layerSet;
                }
                URL reqUrl = URI.create(this.markerLayerStringTemplate.replace("{world}", this.currentDimension.replaceAll(":", "-"))).toURL();
                Pl3xMapMarkerLayerConfig[] markerLayers = (Pl3xMapMarkerLayerConfig[])HTTP.makeJSONHTTPRequest(reqUrl, apiResponseType);
                HashSet<MarkerLayer> layers = new HashSet<MarkerLayer>();
                for (Pl3xMapMarkerLayerConfig layer : markerLayers) {
                    if (Objects.equals(layer.key, "pl3xmap_players")) continue;
                    layers.add(new MarkerLayer(layer.key, layer.label));
                }
                return layers;
            }
            if (this.version == 1) {
                Type apiResponseType = new TypeToken<SquareMapMarkerUpdate[]>(){}.getType();
                if (all) {
                    Pl3xMapConfiguration configuration = HTTP.makeJSONHTTPRequest(URI.create(this.onlineMapConfigLink).toURL(), Pl3xMapConfiguration.class);
                    HashSet<MarkerLayer> layerSet = new HashSet<MarkerLayer>();
                    for (Pl3xMapConfiguration.World ws : configuration.worlds) {
                        SquareMapMarkerUpdate[] mls;
                        for (SquareMapMarkerUpdate ml : mls = (SquareMapMarkerUpdate[])HTTP.makeJSONHTTPRequest(URI.create(this.markerLayerStringTemplate.replace("{world}", ws.name.replaceAll(":", "-"))).toURL(), apiResponseType)) {
                            if (Objects.equals(ml.id, "pl3xmap_players")) continue;
                            layerSet.add(new MarkerLayer(ml.id, ml.name));
                        }
                    }
                    return layerSet;
                }
                URL reqUrl = URI.create(this.markerLayerStringTemplate.replace("{world}", this.currentDimension.replaceAll(":", "-"))).toURL();
                SquareMapMarkerUpdate[] markerLayers = (SquareMapMarkerUpdate[])HTTP.makeJSONHTTPRequest(reqUrl, apiResponseType);
                HashSet<MarkerLayer> layers = new HashSet<MarkerLayer>();
                for (SquareMapMarkerUpdate layer : markerLayers) {
                    if (Objects.equals(layer.id, "pl3xmap_players")) continue;
                    layers.add(new MarkerLayer(layer.id, layer.name));
                }
                return layers;
            }
            throw new IllegalStateException();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

