/*
 *    This file is part of the Map Link mod
 *    licensed under the GNU GPL v3 License.
 *
 *    Copyright (C) 2025  Leander Knüttel and contributors
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package de.the_build_craft.maplink.fabric;

import de.the_build_craft.maplink.common.waypoints.MutablePlayerPosition;
import xaero.hud.minimap.player.tracker.system.ITrackedPlayerReader;

import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;

/**
 * @author Leander Knüttel
 * @version 05.09.2025
 */
public class RemotePlayerTrackerReader implements ITrackedPlayerReader<MutablePlayerPosition>, xaero.map.radar.tracker.system.ITrackedPlayerReader<MutablePlayerPosition> {
    @Override
    public UUID getId(MutablePlayerPosition playerPosition) {
        return playerPosition.uuid;
    }

    @Override
    public double getX(MutablePlayerPosition playerPosition) {
        return playerPosition.getLerpedX();
    }

    @Override
    public double getY(MutablePlayerPosition playerPosition) {
        return playerPosition.getLerpedY();
    }

    @Override
    public double getZ(MutablePlayerPosition playerPosition) {
        return playerPosition.getLerpedZ();
    }

    @Override
    public class_5321<class_1937> getDimension(MutablePlayerPosition playerPosition) {
        return class_310.method_1551().field_1687.method_27983();
    }
}
