/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.neoforge;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.authlib.GameProfile;
import de.the_build_craft.maplink.common.waypoints.MutablePlayerPosition;
import de.the_build_craft.maplink.neoforge.RemotePlayerTrackerReader;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import xaero.common.HudMod;
import xaero.hud.minimap.player.tracker.system.IRenderedPlayerTracker;
import xaero.map.radar.tracker.system.IPlayerTrackerSystem;

public class RemotePlayerTrackerSystem
implements IRenderedPlayerTracker<MutablePlayerPosition>,
IPlayerTrackerSystem<MutablePlayerPosition> {
    private final RemotePlayerTrackerReader reader;
    private final Map<UUID, MutablePlayerPosition> map;
    private static final DecimalFormat precision0 = new DecimalFormat("0");
    private static final DecimalFormat precision1 = new DecimalFormat("0.0");

    public RemotePlayerTrackerSystem(RemotePlayerTrackerReader reader, Map<UUID, MutablePlayerPosition> map) {
        this.reader = reader;
        this.map = map;
    }

    public RemotePlayerTrackerReader getReader() {
        return this.reader;
    }

    public Iterator<MutablePlayerPosition> getTrackedPlayerIterator() {
        return this.map.values().iterator();
    }

    public static String injectDistanceText(GameProfile instance, Operation<String> original, Vec3 pos) {
        if (Minecraft.getInstance().cameraEntity == null) {
            return (String)original.call(new Object[]{instance});
        }
        Vec3 cameraPos = Minecraft.getInstance().cameraEntity.getEyePosition();
        double distance = cameraPos.distanceTo(pos);
        int autoConvertToKmThreshold = HudMod.INSTANCE.getSettings().autoConvertWaypointDistanceToKmThreshold;
        String distanceText = autoConvertToKmThreshold != -1 && distance >= (double)autoConvertToKmThreshold ? precision1.format(distance / 1000.0) + "km" : precision0.format(distance) + "m";
        return distanceText + " | " + (String)original.call(new Object[]{instance});
    }
}

