/*
 * Decompiled with CFR 0.152.
 */
package de.the_build_craft.maplink.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.the_build_craft.maplink.common.CommonModConfig;
import de.the_build_craft.maplink.common.FastUpdateTask;
import de.the_build_craft.maplink.common.LoaderType;
import de.the_build_craft.maplink.common.ModChecker;
import de.the_build_craft.maplink.common.UpdateTask;
import de.the_build_craft.maplink.common.clientMapHandlers.XaeroClientMapHandler;
import de.the_build_craft.maplink.common.connections.MapConnection;
import de.the_build_craft.maplink.common.waypoints.Double3;
import de.the_build_craft.maplink.common.wrappers.Utils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2168;
import net.minecraft.class_310;
import net.minecraft.class_642;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModInitializer {
    public static final String MOD_ID = "maplink";
    public static final String MOD_NAME = "Map Link";
    public static final String VERSION = "4.1.2";
    public static final Logger LOGGER = LogManager.getLogger((String)"MapLink");
    public static AbstractModInitializer INSTANCE;
    public LoaderType loaderType;
    public static int timerDelay;
    public static UpdateTask slowUpdateTask;
    private static FastUpdateTask fastUpdateTask;
    private static ScheduledFuture<?> scheduledSlowUpdateTask;
    private static ScheduledFuture<?> scheduledFastUpdateTask;
    private static MapConnection connection;
    public static boolean connected;
    public static final Map<String, Boolean> AfkMap;
    public static final Map<String, Long> lastPlayerActivityTimeMap;
    public static final Map<String, Double3> lastPlayerPosMap;
    public static final Map<String, Boolean> playerOverAfkTimeMap;
    public static final Map<String, Long> lastPlayerUpdateTimeMap;
    public static boolean xaeroMapInstalled;
    public static boolean overwriteCurrentDimension;
    private static final ScheduledExecutorService scheduler;

    protected abstract void createInitialBindings();

    protected abstract IEventProxy createClientProxy();

    protected abstract IEventProxy createServerProxy(boolean var1);

    protected abstract void initializeModCompat();

    public void onInitializeClient() {
        LOGGER.info("Initializing Map Link");
        this.startup();
        xaeroMapInstalled = ModChecker.INSTANCE.classExists("xaero.minimap.XaeroMinimap") || ModChecker.INSTANCE.classExists("xaero.pvp.BetterPVP");
        LOGGER.info("mapModInstalled: " + xaeroMapInstalled);
        if (xaeroMapInstalled) {
            new XaeroClientMapHandler();
        }
        slowUpdateTask = new UpdateTask();
        fastUpdateTask = new FastUpdateTask();
        scheduledFastUpdateTask = scheduler.scheduleAtFixedRate(fastUpdateTask::run, 0L, 100L, TimeUnit.MILLISECONDS);
        scheduledSlowUpdateTask = scheduler.scheduleAtFixedRate(slowUpdateTask::run, 0L, timerDelay, TimeUnit.MILLISECONDS);
        this.printModInfo();
        this.createClientProxy().registerEvents();
        this.createServerProxy(false).registerEvents();
        this.initializeModCompat();
        LOGGER.info("Map Link Initialized");
    }

    public void onInitializeServer() {
        LOGGER.info("Initializing Map Link");
        this.startup();
        this.printModInfo();
        this.createServerProxy(true).registerEvents();
        LOGGER.info("Map Link Initialized");
    }

    private void startup() {
        INSTANCE = this;
        this.createInitialBindings();
    }

    private void printModInfo() {
        LOGGER.info("Map Link, Version: 4.1.2");
    }

    public static void registerClientCommands(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder<class_2168> baseCommand = AbstractModInitializer.literal(MOD_ID);
        LiteralArgumentBuilder ignoreCommand = (LiteralArgumentBuilder)baseCommand.then(AbstractModInitializer.literal("ignore_server").executes(context -> {
            AbstractModInitializer.IgnoreServer();
            return 1;
        }));
        dispatcher.register(ignoreCommand);
        LiteralArgumentBuilder setAfkTimeCommand = (LiteralArgumentBuilder)baseCommand.then(AbstractModInitializer.literal("set_afk_time").then(AbstractModInitializer.argument("player", StringArgumentType.word()).then(AbstractModInitializer.argument("time", IntegerArgumentType.integer((int)0)).executes(context -> {
            String playerName = StringArgumentType.getString((CommandContext)context, (String)"player");
            int time = IntegerArgumentType.getInteger((CommandContext)context, (String)"time");
            lastPlayerActivityTimeMap.put(playerName, System.currentTimeMillis() - (long)time * 1000L);
            AfkMap.put(playerName, time >= Math.max(30, CommonModConfig.config.general.timeUntilAfk));
            Utils.sendToClientChat("Set AFK time for " + playerName + " to " + time);
            return 1;
        }))));
        dispatcher.register(setAfkTimeCommand);
        LiteralArgumentBuilder setCurrentDimensionCommand = (LiteralArgumentBuilder)baseCommand.then(AbstractModInitializer.literal("set_current_dimension").then(AbstractModInitializer.argument("dimension", StringArgumentType.word()).executes(context -> {
            if (connection == null) {
                Utils.sendErrorToClientChat("Not connected to a server!");
            } else {
                String dimension = StringArgumentType.getString((CommandContext)context, (String)"dimension");
                connection.setCurrentDimension(dimension);
                Utils.sendToClientChat("Set current-dimension to: " + dimension);
            }
            return 1;
        })));
        dispatcher.register(setCurrentDimensionCommand);
        LiteralArgumentBuilder setCurrentDimensionOverwriteCommand = (LiteralArgumentBuilder)baseCommand.then(AbstractModInitializer.literal("set_current_dimension_overwrite").then(AbstractModInitializer.argument("on", StringArgumentType.word()).executes(context -> {
            overwriteCurrentDimension = Boolean.parseBoolean(StringArgumentType.getString((CommandContext)context, (String)"on"));
            Utils.sendToClientChat("Set dimension-overwrite to: " + overwriteCurrentDimension);
            return 1;
        })));
        dispatcher.register(setCurrentDimensionOverwriteCommand);
        LiteralArgumentBuilder openOnlineMapConfig = (LiteralArgumentBuilder)baseCommand.then(AbstractModInitializer.literal("open_online_map_config").executes(context -> {
            if (connection == null) {
                Utils.sendErrorToClientChat("Not connected to a server!");
            } else {
                connection.OpenOnlineMapConfig();
            }
            return 1;
        }));
        dispatcher.register(openOnlineMapConfig);
        LiteralArgumentBuilder ignoreMarkerMessageCommand = (LiteralArgumentBuilder)baseCommand.then(AbstractModInitializer.literal("ignore_marker_message").executes(context -> {
            CommonModConfig.setIgnoreMarkerMessage(true);
            Utils.sendToClientChat("You will not receive this warning again!");
            return 1;
        }));
        dispatcher.register(ignoreMarkerMessageCommand);
    }

    public static void registerServerCommands(CommandDispatcher<class_2168> dispatcher, boolean allOrDedicated) {
    }

    private static LiteralArgumentBuilder<class_2168> literal(String string) {
        return LiteralArgumentBuilder.literal((String)string);
    }

    private static <T> RequiredArgumentBuilder<class_2168, T> argument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    public static void setUpdateDelay(int ms) {
        int maxUpdateDelay = Math.min(4000, Math.max(CommonModConfig.config.general.maxUpdateDelay, 1000));
        ms = Math.min(maxUpdateDelay, Math.max(ms, 1000));
        if (ms == timerDelay || scheduledSlowUpdateTask == null) {
            return;
        }
        timerDelay = ms;
        scheduledSlowUpdateTask.cancel(true);
        scheduledSlowUpdateTask = scheduler.scheduleAtFixedRate(slowUpdateTask::run, 0L, timerDelay, TimeUnit.MILLISECONDS);
        LOGGER.info("Remote update delay has been set to " + ms + " ms");
        if (CommonModConfig.config.general.debugMode) {
            Utils.sendToClientChat("Remote update delay has been set to " + ms + " ms");
        }
    }

    public static void setConnection(MapConnection connection) {
        connected = connection != null;
        AbstractModInitializer.connection = connection;
    }

    @Nullable
    public static MapConnection getConnection() {
        return connection;
    }

    public static void IgnoreServer() {
        class_642 server = class_310.method_1551().method_1558();
        if (server != null) {
            String address = server.field_3761.toLowerCase(Locale.ROOT);
            if (!CommonModConfig.config.general.ignoredServers.contains(address)) {
                CommonModConfig.config.general.ignoredServers.add(address);
            }
            CommonModConfig.saveConfig();
            Utils.sendToClientChat("You will not receive this warning again!");
        } else {
            Utils.sendToClientChat("This can only be executed on a server!");
        }
    }

    public static String[] getModIdAliases(String id) {
        HashMap<String, String[]> modIdAliases = new HashMap<String, String[]>();
        modIdAliases.put("xaerominimap", new String[]{"xaerominimapfair", "xaerobetterpvp", "xaerobetterpvpfair"});
        if (modIdAliases.containsKey(id)) {
            return (String[])modIdAliases.get(id);
        }
        return new String[]{id};
    }

    public static boolean checkIfInGame() {
        class_310 mc = class_310.method_1551();
        return mc.field_1687 != null && mc.field_1724 != null && mc.field_1719 != null;
    }

    public static boolean checkIfInSingleplayer() {
        return class_310.method_1551().method_1576() != null;
    }

    public static boolean checkIfInMultiplayer() {
        class_310 mc = class_310.method_1551();
        return mc.method_1558() != null && mc.method_1562() != null && mc.method_1562().method_48296().method_10758();
    }

    @Nullable
    public static String getCurrentServerIP() {
        if (AbstractModInitializer.checkIfInSingleplayer()) {
            return "lan";
        }
        if (AbstractModInitializer.checkIfInMultiplayer()) {
            return class_310.method_1551().method_1558().field_3761.toLowerCase(Locale.ROOT);
        }
        return null;
    }

    static {
        timerDelay = 1000;
        connection = null;
        connected = false;
        AfkMap = new ConcurrentHashMap<String, Boolean>();
        lastPlayerActivityTimeMap = new ConcurrentHashMap<String, Long>();
        lastPlayerPosMap = new HashMap<String, Double3>();
        playerOverAfkTimeMap = new ConcurrentHashMap<String, Boolean>();
        lastPlayerUpdateTimeMap = new HashMap<String, Long>();
        xaeroMapInstalled = false;
        overwriteCurrentDimension = false;
        scheduler = Executors.newScheduledThreadPool(2);
    }

    public static interface IEventProxy {
        public void registerEvents();
    }
}

