/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.telepathicmaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.FoxScrollMessage;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mafuyu404.telepathicmaid.api.MoveControlAccessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MaidUtil {
    public static Map<String, List<FoxScrollMessage.FoxScrollData>> getFoxScrollData(Player player) {
        HashMap data = Maps.newHashMap();
        MaidWorldData maidWorldData = MaidWorldData.get((Level)player.m_9236_());
        if (maidWorldData == null) {
            return null;
        }
        List<MaidInfo> maidInfos = maidWorldData.getPlayerMaidInfos(player);
        if (maidInfos == null) {
            maidInfos = Collections.emptyList();
        }
        maidInfos.forEach(info -> {
            List scrollData = data.computeIfAbsent(info.getDimension(), dim -> Lists.newArrayList());
            scrollData.add(new FoxScrollMessage.FoxScrollData(info.getChunkPos(), info.getName(), info.getTimestamp()));
        });
        return data;
    }

    public static void setOperation(EntityMaid maid, String op) {
        ((MoveControlAccessor)maid.m_21566_()).setMove(op);
    }

    public static String getMaidIdOfScrollData(FoxScrollMessage.FoxScrollData foxScrollData) {
        ComponentContents contents = foxScrollData.getName().m_214077_();
        if (contents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)contents;
            String key = translatable.m_237508_();
            key = key.replace("model.", "");
            key = key.replace(".name", "");
            key = key.replace(".", ":");
            return key;
        }
        return null;
    }

    public static String getMaidIdOfGarageKit(ItemStack itemStack) {
        CompoundTag nbt;
        CompoundTag info;
        if (itemStack.m_41782_() && (info = (CompoundTag)(nbt = itemStack.m_41783_()).m_128423_("EntityInfo")) != null) {
            return info.m_128461_("ModelId");
        }
        return null;
    }

    public static boolean matchMaidModelId(EntityMaid maid, String id) {
        return maid.getModelId().equals(id);
    }

    public static boolean matchMaid(Entity entity, Player player) {
        if (player == null) {
            return false;
        }
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            String maidId = MaidUtil.getMaidIdOfGarageKit(player.m_21205_());
            UUID GarageKitUUID = MaidUtil.getGarageKitUUID(player.m_21205_());
            boolean matchModelId = MaidUtil.matchMaidModelId(maid, maidId);
            boolean matchOwner = maid.m_21805_() != null && maid.m_21805_().equals(player.m_20148_());
            boolean matchMaidUUID = GarageKitUUID != null && GarageKitUUID.equals(maid.m_20148_());
            return matchModelId && matchOwner && matchMaidUUID;
        }
        return false;
    }

    public static UUID getGarageKitUUID(ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_("StoredMaidUUID")) {
            return itemStack.m_41783_().m_128342_("StoredMaidUUID");
        }
        return null;
    }
}

