/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.telepathicmaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.FoxScrollMessage;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mafuyu404.telepathicmaid.api.MoveControlAccessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2588;
import net.minecraft.class_7417;

public class MaidUtil {
    public static Map<String, List<FoxScrollMessage.FoxScrollData>> getFoxScrollData(class_1657 player) {
        HashMap data = Maps.newHashMap();
        MaidWorldData maidWorldData = MaidWorldData.get((class_1937)player.method_37908());
        if (maidWorldData == null) {
            return null;
        }
        List<MaidInfo> maidInfos = maidWorldData.getPlayerMaidInfos(player);
        if (maidInfos == null) {
            maidInfos = Collections.emptyList();
        }
        maidInfos.forEach(info -> {
            List scrollData = data.computeIfAbsent(info.getDimension(), dim -> Lists.newArrayList());
            scrollData.add(new FoxScrollMessage.FoxScrollData(info.getChunkPos(), info.getName(), info.getTimestamp()));
        });
        return data;
    }

    public static void setOperation(EntityMaid maid, String op) {
        ((MoveControlAccessor)maid.method_5962()).setMove(op);
    }

    public static String getMaidIdOfScrollData(FoxScrollMessage.FoxScrollData foxScrollData) {
        class_7417 contents = foxScrollData.getName().method_10851();
        if (contents instanceof class_2588) {
            class_2588 translatable = (class_2588)contents;
            String key = translatable.method_11022();
            key = key.replace("model.", "");
            key = key.replace(".name", "");
            key = key.replace(".", ":");
            return key;
        }
        return null;
    }

    public static String getMaidIdOfGarageKit(class_1799 itemStack) {
        class_2487 nbt = itemStack.method_7948();
        class_2487 info = (class_2487)nbt.method_10580("EntityInfo");
        if (info != null) {
            return info.method_10558("ModelId");
        }
        return null;
    }

    public static boolean matchMaidModelId(EntityMaid maid, String id) {
        return maid.getModelId().equals(id);
    }

    public static boolean matchMaid(class_1297 entity, class_1657 player) {
        if (player == null) {
            return false;
        }
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            String maidId = MaidUtil.getMaidIdOfGarageKit(player.method_6047());
            UUID GarageKitUUID = MaidUtil.getGarageKitUUID(player.method_6047());
            boolean matchModelId = MaidUtil.matchMaidModelId(maid, maidId);
            boolean matchOwner = maid.method_6139() != null && maid.method_6139().equals(player.method_5667());
            boolean matchMaidUUID = GarageKitUUID != null && GarageKitUUID.equals(maid.method_5667());
            return matchModelId && matchOwner && matchMaidUUID;
        }
        return false;
    }

    public static UUID getGarageKitUUID(class_1799 itemStack) {
        class_2487 nbt = itemStack.method_7948();
        if (!nbt.method_10545("StoredMaidUUID")) {
            return null;
        }
        return itemStack.method_7948().method_25926("StoredMaidUUID");
    }
}

