/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.telepathicmaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.ItemGarageKit;
import com.mafuyu404.diligentstalker.utils.ClientStalkerUtil;
import com.mafuyu404.telepathicmaid.util.MaidUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.lwjgl.glfw.GLFW;

public class ClientMaidUtil {
    public static EntityMaid findLoadedMaid() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        String targetedId = MaidUtil.getMaidIdOfGarageKit(player.m_21205_());
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return null;
        }
        for (Entity entity : level.m_104735_()) {
            EntityMaid maid;
            if (!(entity instanceof EntityMaid) || !MaidUtil.matchMaidModelId(maid = (EntityMaid)entity, targetedId)) continue;
            return maid;
        }
        return null;
    }

    public static boolean isKeyPressedOfDesc(String key) {
        boolean result = false;
        for (KeyMapping keyMapping : Minecraft.m_91087_().f_91066_.f_92059_) {
            if (!key.equals(keyMapping.m_90860_()) || !keyMapping.m_90857_()) continue;
            result = true;
        }
        return result;
    }

    public static boolean isKeyPressed(int glfwKeyCode) {
        Minecraft minecraft = Minecraft.m_91087_();
        long windowHandle = minecraft.m_91268_().m_85439_();
        return GLFW.glfwGetKey((long)windowHandle, (int)glfwKeyCode) == 1;
    }

    public static boolean isHoldingGarageKit() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        return player.m_21205_().m_41720_() instanceof ItemGarageKit;
    }

    public static boolean isUsingGarageKit() {
        return ClientMaidUtil.isHoldingGarageKit() && ClientMaidUtil.isKeyPressedOfDesc("key.use");
    }

    public static boolean matchMaid(Entity entity) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return MaidUtil.matchMaid(entity, (Player)player);
    }

    public static EntityMaid getControllingMaid() {
        Entity entity = ClientStalkerUtil.getLocalStalker();
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            return maid;
        }
        return null;
    }

    public static Entity getTargetedEntity(Entity entity, double maxDistance) {
        HitResult hitResult = entity.m_19907_(maxDistance, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult entityHit = (EntityHitResult)hitResult;
            return entityHit.m_82443_();
        }
        return null;
    }
}

