/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.telepathicmaid.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;

public class OutlineRenderer {
    private static final float OUTLINE_SCALE = 1.05f;
    private static final float[] GOLD_COLOR = new float[]{1.0f, 0.84f, 0.0f, 0.8f};

    public static void renderOutline(PoseStack poseStack, MultiBufferSource buffer, LivingEntity entity, float partialTicks) {
        EntityRenderDispatcher renderer = Minecraft.m_91087_().m_91290_();
        EntityRenderer entityRenderer = renderer.m_114382_((Entity)entity);
        if (!(entityRenderer instanceof LivingEntityRenderer)) {
            return;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)entityRenderer;
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172808_);
        RenderSystem.setShaderColor((float)GOLD_COLOR[0], (float)GOLD_COLOR[1], (float)GOLD_COLOR[2], (float)GOLD_COLOR[3]);
        RenderSystem.polygonMode((int)1032, (int)6913);
        VertexConsumer outlineBuffer = buffer.m_6299_(RenderType.m_110504_());
        float yOffset = entity.m_20206_() / 2.0f;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, yOffset, 0.0f);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
        poseStack.m_85837_(0.0, (double)(-yOffset) + 1.5, 0.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(entity.f_20883_));
        livingRenderer.m_7200_().m_7695_(poseStack, outlineBuffer, 0xF000F0, 3, GOLD_COLOR[0], GOLD_COLOR[1], GOLD_COLOR[2], GOLD_COLOR[3]);
        poseStack.m_85849_();
        RenderSystem.polygonMode((int)1032, (int)6914);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderOutlineBox(PoseStack poseStack, VertexConsumer consumer, Matrix4f matrix, AABB aabb, float r, float g, float b, float a) {
        float minX = (float)aabb.f_82288_;
        float minY = (float)aabb.f_82289_;
        float minZ = (float)aabb.f_82290_;
        float maxX = (float)aabb.f_82291_;
        float maxY = (float)aabb.f_82292_;
        float maxZ = (float)aabb.f_82293_;
        OutlineRenderer.line(consumer, matrix, minX, minY, minZ, maxX, minY, minZ, r, g, b, a);
        OutlineRenderer.line(consumer, matrix, maxX, minY, minZ, maxX, minY, maxZ, r, g, b, a);
        OutlineRenderer.line(consumer, matrix, maxX, minY, maxZ, minX, minY, maxZ, r, g, b, a);
        OutlineRenderer.line(consumer, matrix, minX, minY, maxZ, minX, minY, minZ, r, g, b, a);
        OutlineRenderer.line(consumer, matrix, minX, maxY, minZ, maxX, maxY, minZ, r, g, b, a);
        OutlineRenderer.line(consumer, matrix, maxX, maxY, minZ, maxX, maxY, maxZ, r, g, b, a);
        OutlineRenderer.line(consumer, matrix, maxX, maxY, maxZ, minX, maxY, maxZ, r, g, b, a);
        OutlineRenderer.line(consumer, matrix, minX, maxY, maxZ, minX, maxY, minZ, r, g, b, a);
        OutlineRenderer.line(consumer, matrix, minX, minY, minZ, minX, maxY, minZ, r, g, b, a);
        OutlineRenderer.line(consumer, matrix, maxX, minY, minZ, maxX, maxY, minZ, r, g, b, a);
        OutlineRenderer.line(consumer, matrix, maxX, minY, maxZ, maxX, maxY, maxZ, r, g, b, a);
        OutlineRenderer.line(consumer, matrix, minX, minY, maxZ, minX, maxY, maxZ, r, g, b, a);
    }

    private static void line(VertexConsumer consumer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, float r, float g, float b, float a) {
        consumer.m_252986_(matrix, x1, y1, z1).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, x2, y2, z2).m_85950_(r, g, b, a).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }
}

