/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.telepathicmaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.ItemGarageKit;
import com.github.tartaricacid.touhoulittlemaid.network.message.FoxScrollMessage;
import com.mafuyu404.telepathicmaid.util.MaidUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ServerMaidUtil {
    public static BlockPos findUnloadedMaid(Player player) {
        Level level = player.m_9236_();
        ItemStack itemStack = player.m_21205_();
        if (!(itemStack.m_41720_() instanceof ItemGarageKit)) {
            return null;
        }
        String levelName = level.m_46472_().m_135782_().toString();
        Map<String, List<FoxScrollMessage.FoxScrollData>> data = MaidUtil.getFoxScrollData(player);
        if (data == null) {
            return null;
        }
        List<FoxScrollMessage.FoxScrollData> dataList = data.get(levelName);
        if (dataList == null) {
            return null;
        }
        BlockPos result = null;
        for (FoxScrollMessage.FoxScrollData foxScrollData : dataList) {
            if (!Objects.equals(MaidUtil.getMaidIdOfGarageKit(itemStack), MaidUtil.getMaidIdOfScrollData(foxScrollData))) continue;
            result = foxScrollData.getPos();
        }
        return result;
    }

    public static EntityMaid findLoadedMaid(Player player) {
        ServerLevel serverLevel = (ServerLevel)player.m_9236_();
        String maidId = MaidUtil.getMaidIdOfGarageKit(player.m_21205_());
        for (Entity entity : serverLevel.m_142646_().m_142273_()) {
            EntityMaid maid;
            if (!(entity instanceof EntityMaid) || !MaidUtil.matchMaidModelId(maid = (EntityMaid)entity, maidId)) continue;
            return maid;
        }
        return null;
    }
}

