/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.telepathicmaid.util;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntitySightTracker {
    public static Entity trackTargetEntity(Entity origin, double range) {
        if (!origin.m_9236_().f_46443_) {
            return null;
        }
        Vec3 eyePosition = origin.m_20299_(1.0f);
        Vec3 lookVec = origin.m_20252_(1.0f);
        Vec3 endPoint = eyePosition.m_82549_(lookVec.m_82490_(range));
        Predicate<Entity> filter = entity -> entity != null && entity.m_6084_() && entity.m_6087_() && entity != origin && !origin.m_20365_(entity);
        EntityHitResult result = EntitySightTracker.rayTraceEntities(origin.m_9236_(), origin, eyePosition, endPoint, new AABB(eyePosition, endPoint).m_82400_(1.0), filter, range);
        return result != null ? result.m_82443_() : null;
    }

    private static EntityHitResult rayTraceEntities(Level world, Entity origin, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, double range) {
        List entities = world.m_6249_(origin, boundingBox, filter);
        Entity closestEntity = null;
        Vec3 closestHit = null;
        double minDistance = range;
        for (Entity entity : entities) {
            double distance;
            AABB entityBox = entity.m_20191_().m_82400_((double)entity.m_6143_());
            Vec3 hitVec = entityBox.m_82371_(startVec, endVec).orElse(null);
            if (hitVec == null || !((distance = startVec.m_82554_(hitVec)) < minDistance)) continue;
            closestEntity = entity;
            closestHit = hitVec;
            minDistance = distance;
        }
        return closestEntity != null ? new EntityHitResult(closestEntity, closestHit) : null;
    }
}

