/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class BuriedModel<T extends Entity>
extends EntityModel<T> {
    private final ModelPart buried;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart legs;
    private final ModelPart arms;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart rightArm;
    private final ModelPart leftArm;

    public BuriedModel(ModelPart root) {
        this.buried = root.getChild("buried");
        this.head = this.buried.getChild("Head");
        this.body = this.buried.getChild("Body");
        this.legs = this.buried.getChild("Body").getChild("Legs");
        this.arms = this.buried.getChild("Body").getChild("Arms");
        this.leftLeg = this.buried.getChild("Body").getChild("Legs").getChild("LeftLeg");
        this.rightLeg = this.buried.getChild("Body").getChild("Legs").getChild("RightLeg");
        this.rightArm = this.buried.getChild("Body").getChild("Arms").getChild("RightArm");
        this.leftArm = this.buried.getChild("Body").getChild("Arms").getChild("LeftArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition buried = partdefinition.addOrReplaceChild("buried", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)34.0f, (float)-6.0f));
        PartDefinition Head = buried.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -6.0f, -8.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-13.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)-0.1309f));
        PartDefinition Body = buried.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-13.0f, (float)0.0f, (float)1.4835f, (float)0.0f, (float)0.0f));
        PartDefinition Legs = Body.addOrReplaceChild("Legs", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)1.0f, (float)0.0f));
        PartDefinition LeftLeg = Legs.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(32, 0).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(-2, 2).mirror().addBox(-1.0f, 6.0f, -1.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)11.0f, (float)0.0f, (float)-0.0444f, (float)-0.0852f, (float)-0.112f));
        PartDefinition RightLeg = Legs.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(32, 16).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(2, 2).mirror().addBox(-1.0f, 5.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-6.0f, (float)12.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition Arms = Body.addOrReplaceChild("Arms", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)13.0f, (float)1.0f));
        PartDefinition LeftArm = Arms.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(40, 0).mirror().addBox(-1.0f, -1.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(-2, 0).mirror().addBox(-1.0f, 5.0f, -1.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)7.0f, (float)-12.0f, (float)-1.0f, (float)-2.7213f, (float)-0.0735f, (float)0.4305f));
        PartDefinition RightArm = Arms.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(2, 0).mirror().addBox(-1.0f, 5.0f, -1.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(40, 16).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-12.0f, (float)-1.0f, (float)-2.7242f, (float)0.4157f, (float)-0.1073f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (this.head.yRot != 0.0f) {
            this.body.yRot = this.head.yRot / 10.0f;
            this.body.zRot = this.head.yRot / 10.0f;
            this.legs.xRot = -this.head.yRot / 8.0f;
            this.arms.xRot = this.head.yRot / 8.0f;
        }
        if (this.head != null) {
            this.head.xRot = pHeadPitch * ((float)Math.PI / 180);
            this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.buried.render(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

