/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.model.deer;

import com.farcr.nomansland.common.entity.deer.Deer;
import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DeerModel<T extends Deer>
extends QuadrupedModel<T> {
    protected final ModelPart babyHead;
    protected final ModelPart babyBody;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart babyRightHindLeg;
    private final ModelPart babyLeftHindLeg;
    private final ModelPart babyRightFrontLeg;
    private final ModelPart babyLeftFrontLeg;

    public DeerModel(ModelPart root) {
        super(root, false, 0.0f, 0.0f, 1.0f, 1.0f, 0);
        this.rightFrontLeg = root.getChild("right_front_leg");
        this.rightHindLeg = root.getChild("right_hind_leg");
        this.leftFrontLeg = root.getChild("left_front_leg");
        this.leftHindLeg = root.getChild("left_hind_leg");
        this.babyBody = root.getChild("baby_body");
        this.babyHead = root.getChild("baby_head");
        this.babyRightFrontLeg = root.getChild("baby_right_front_leg");
        this.babyRightHindLeg = root.getChild("baby_right_hind_leg");
        this.babyLeftFrontLeg = root.getChild("baby_left_front_leg");
        this.babyLeftHindLeg = root.getChild("baby_left_hind_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -4.0f, -8.5f, 8.0f, 8.0f, 17.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)-0.5f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 23).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)-4.0f, (float)9.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -11.0f, -4.0f, 4.0f, 11.0f, 5.0f).texOffs(0, 16).addBox(-1.5f, -10.0f, -8.0f, 3.0f, 3.0f, 4.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)-7.0f));
        PartDefinition left_antler = head.addOrReplaceChild("left_antler", CubeListBuilder.create(), PartPose.offset((float)4.3036f, (float)-14.6911f, (float)0.5648f));
        PartDefinition cube_r1 = left_antler.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 41).addBox(-1.0f, -4.0f, -5.5f, 2.0f, 8.0f, 11.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)0.3491f, (float)0.2618f));
        PartDefinition right_antler = head.addOrReplaceChild("right_antler", CubeListBuilder.create(), PartPose.offset((float)-4.3036f, (float)-14.6911f, (float)0.5648f));
        PartDefinition cube_r2 = right_antler.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 41).mirror().addBox(-1.0f, -4.0f, -5.5f, 2.0f, 8.0f, 11.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)-0.3491f, (float)-0.2618f));
        PartDefinition right_ear = head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(18, 13).addBox(-1.5f, -1.0f, 0.0f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-3.0786f, (float)-10.3542f, (float)0.5029f, (float)0.1201f, (float)0.4205f, (float)0.2875f));
        PartDefinition left_ear = head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(18, 13).mirror().addBox(-1.5f, -1.0f, 0.0f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.01f)).mirror(false), PartPose.offsetAndRotation((float)3.0786f, (float)-10.3542f, (float)0.5029f, (float)0.1201f, (float)-0.4205f, (float)-0.2875f));
        PartDefinition right_front_leg = partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 11.0f, 2.0f), PartPose.offset((float)-3.0f, (float)13.0f, (float)-5.0f));
        PartDefinition right_hind_leg = partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(34, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 11.0f, 2.0f), PartPose.offset((float)-3.0f, (float)13.0f, (float)7.0f));
        PartDefinition left_front_leg = partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(26, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 11.0f, 2.0f), PartPose.offset((float)3.0f, (float)13.0f, (float)-5.0f));
        PartDefinition left_hind_leg = partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(42, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 11.0f, 2.0f), PartPose.offset((float)3.0f, (float)13.0f, (float)7.0f));
        PartDefinition baby_body = partdefinition.addOrReplaceChild("baby_body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -2.0f, -3.5f, 4.0f, 4.0f, 7.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition baby_tail = baby_body.addOrReplaceChild("baby_tail", CubeListBuilder.create().texOffs(0, 11).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)3.5f));
        PartDefinition baby_head = partdefinition.addOrReplaceChild("baby_head", CubeListBuilder.create().texOffs(22, 0).addBox(-1.5f, -6.0f, -0.25f, 3.0f, 6.0f, 3.0f).texOffs(8, 11).addBox(-1.0f, -5.0f, -2.25f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)-4.25f));
        PartDefinition baby_right_ear = baby_head.addOrReplaceChild("baby_right_ear", CubeListBuilder.create().texOffs(20, 0).mirror().addBox(-2.0f, -2.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.01f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)-4.0f, (float)2.25f, (float)0.0f, (float)0.5236f, (float)0.1745f));
        PartDefinition baby_left_ear = baby_head.addOrReplaceChild("baby_left_ear", CubeListBuilder.create().texOffs(20, 0).addBox(0.0f, -2.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)1.5f, (float)-4.0f, (float)2.25f, (float)0.0f, (float)-0.5236f, (float)-0.1745f));
        PartDefinition baby_right_front_leg = partdefinition.addOrReplaceChild("baby_right_front_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.offset((float)-1.5f, (float)19.0f, (float)-2.0f));
        PartDefinition baby_right_hind_leg = partdefinition.addOrReplaceChild("baby_right_hind_leg", CubeListBuilder.create().texOffs(15, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.offset((float)-1.5f, (float)19.0f, (float)3.0f));
        PartDefinition baby_left_front_leg = partdefinition.addOrReplaceChild("baby_left_front_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.offset((float)1.5f, (float)19.0f, (float)-2.0f));
        PartDefinition baby_left_hind_leg = partdefinition.addOrReplaceChild("baby_left_hind_leg", CubeListBuilder.create().texOffs(15, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.offset((float)1.5f, (float)19.0f, (float)3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T deer, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(deer, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.head.xRot /= 3.0f;
        this.head.yRot /= 3.0f;
        this.babyHead.xRot = this.head.xRot / 2.0f;
        this.babyHead.yRot = this.head.yRot / 2.0f;
        this.babyRightFrontLeg.xRot = this.rightFrontLeg.xRot / 2.0f;
        this.babyRightHindLeg.xRot = this.rightHindLeg.xRot / 2.0f;
        this.babyLeftFrontLeg.xRot = this.leftFrontLeg.xRot / 2.0f;
        this.babyLeftHindLeg.xRot = this.leftHindLeg.xRot / 2.0f;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        boolean baby = entity.isBaby();
        this.head.visible = !baby;
        this.body.visible = !baby;
        this.rightHindLeg.visible = !baby;
        this.leftHindLeg.visible = !baby;
        this.rightFrontLeg.visible = !baby;
        this.leftFrontLeg.visible = !baby;
        this.babyHead.visible = baby;
        this.babyBody.visible = baby;
        this.babyRightHindLeg.visible = baby;
        this.babyLeftHindLeg.visible = baby;
        this.babyRightFrontLeg.visible = baby;
        this.babyLeftFrontLeg.visible = baby;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head, (Object)this.babyHead);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightFrontLeg, (Object)this.rightHindLeg, (Object)this.leftFrontLeg, (Object)this.leftHindLeg, (Object)this.babyBody, (Object)this.babyRightFrontLeg, (Object)this.babyRightHindLeg, (Object)this.babyLeftFrontLeg, (Object)this.babyLeftHindLeg);
    }
}

