/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.model.tortoise;

import com.farcr.nomansland.client.model.tortoise.TortoiseAnimation;
import com.farcr.nomansland.common.entity.tortoise.Tortoise;
import net.minecraft.client.model.AgeableHierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class TortoiseModel<T extends Tortoise>
extends AgeableHierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;

    public TortoiseModel(ModelPart root) {
        super(0.16666667f, 120.0f);
        this.root = root;
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 37).addBox(-9.0f, -15.0f, -1.0f, 18.0f, 15.0f, 22.0f, new CubeDeformation(0.5f)).texOffs(0, 0).addBox(-9.0f, -15.0f, -1.0f, 18.0f, 15.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.0f, (float)-10.0f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 37).addBox(-9.0f, -15.0f, -1.0f, 18.0f, 15.0f, 22.0f, new CubeDeformation(0.5f)).texOffs(0, 0).addBox(-9.0f, -15.0f, -1.0f, 18.0f, 15.0f, 22.0f, false), PartPose.offset((float)0.0f, (float)20.0f, (float)-10.0f));
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(26, 74).addBox(-2.0f, -2.0f, -6.0f, 4.0f, 4.0f, 8.0f, false).texOffs(80, 0).addBox(-2.0f, -6.0f, -6.0f, 4.0f, 4.0f, 4.0f, false).texOffs(0, 74).addBox(-3.0f, -11.0f, -9.0f, 6.0f, 5.0f, 7.0f, false), PartPose.offset((float)0.0f, (float)17.0f, (float)-11.0f));
        root.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(50, 74).addBox(-2.5f, -4.0f, -2.5f, 5.0f, 8.0f, 5.0f, true), PartPose.offsetAndRotation((float)-8.8536f, (float)20.0f, (float)-10.8536f, (float)0.0f, (float)0.7854f, (float)0.0f));
        root.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(50, 74).addBox(-2.5f, -4.0f, -2.5f, 5.0f, 8.0f, 5.0f, false), PartPose.offsetAndRotation((float)8.8536f, (float)20.0f, (float)-10.8536f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        root.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(50, 74).addBox(-2.5f, -4.0f, -2.5f, 5.0f, 8.0f, 5.0f, true), PartPose.offsetAndRotation((float)-8.8536f, (float)20.0f, (float)10.8536f, (float)0.0f, (float)0.7854f, (float)0.0f));
        root.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(50, 74).addBox(-2.5f, -4.0f, -2.5f, 5.0f, 8.0f, 5.0f, false), PartPose.offsetAndRotation((float)8.8536f, (float)20.0f, (float)10.8536f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public void setupAnim(T tortoise, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.animateWalk(TortoiseAnimation.TORTOISE_WALK, limbSwing, limbSwingAmount, 15.0f, 200.0f);
        this.animate(((Tortoise)((Object)tortoise)).emergingAnimationState, TortoiseAnimation.TORTOISE_EMERGE, ageInTicks);
        this.animate(((Tortoise)((Object)tortoise)).hidingAnimationState, TortoiseAnimation.TORTOISE_HIDE, ageInTicks);
        this.animate(((Tortoise)((Object)tortoise)).layingEggAnimationState, TortoiseAnimation.TORTOISE_LAY_EGG, ageInTicks);
        if (this.young) {
            this.head.xRot /= 2.0f;
            this.head.yRot /= 2.0f;
            this.applyStatic(TortoiseAnimation.BABY_TRANSFORM);
        }
    }

    public ModelPart root() {
        return this.root;
    }
}

