/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.particle;

import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class BubbleParticle
extends net.minecraft.client.particle.BubbleParticle {
    private final Supplier<SimpleParticleType> popParticle;

    public BubbleParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet, Supplier<SimpleParticleType> popParticle) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.setSprite(spriteSet.get(1, 1));
        this.popParticle = popParticle;
        this.lifetime = (int)(64.0 / (Math.random() * 0.8 + 0.2));
    }

    public void tick() {
        if (this.lifetime-- <= 0) {
            float offset = (float)this.random.nextInt(-10, 10) * 0.01f;
            if (this.popParticle != null) {
                this.level.addParticle((ParticleOptions)this.popParticle.get(), this.x + (double)offset * Math.random(), this.y, this.z + (double)offset * Math.random(), 0.0, 0.0, 0.0);
            }
            float volume = Mth.randomBetween((RandomSource)this.random, (float)0.3f, (float)1.0f);
            this.level.playLocalSound(this.x, this.y, this.z, SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, SoundSource.BLOCKS, volume, 0.7f, false);
            this.remove();
        }
    }
}

