/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.particle;

import com.farcr.nomansland.client.particle.TranslucentDustParticleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TranslucentDustParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    public TranslucentDustParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, TranslucentDustParticleOptions options, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.friction = 0.96f;
        this.speedUpWhenYMotionIsBlocked = true;
        this.sprites = sprites;
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        this.quadSize *= 0.75f;
        int i = (int)(8.0 / (this.random.nextDouble() * 0.8 + 0.2));
        this.lifetime = Math.max(i, 1);
        this.setSpriteFromAge(sprites);
        float f = this.random.nextFloat() * 0.4f + 0.6f;
        this.rCol = this.randomizeColor(options.getRed(), f);
        this.gCol = this.randomizeColor(options.getGreen(), f);
        this.bCol = this.randomizeColor(options.getGreen(), f);
        this.alpha = options.getAlpha();
    }

    protected float randomizeColor(float coordMultiplier, float multiplier) {
        return (this.random.nextFloat() * 0.2f + 0.8f) * coordMultiplier * multiplier;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public float getQuadSize(float scaleFactor) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + scaleFactor) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<TranslucentDustParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(TranslucentDustParticleOptions type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new TranslucentDustParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, type, this.sprites);
        }
    }
}

