/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block;

import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class BuddingQuartziteBlock
extends BuddingAmethystBlock {
    public static final MapCodec<BuddingAmethystBlock> CODEC = BuddingQuartziteBlock.simpleCodec(BuddingQuartziteBlock::new);
    public static final int GROWTH_CHANCE = 5;
    private static final Direction[] DIRECTIONS = Direction.values();

    public MapCodec<BuddingAmethystBlock> codec() {
        return CODEC;
    }

    public BuddingQuartziteBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.nextInt(5) == 0) {
            Direction direction = DIRECTIONS[pRandom.nextInt(DIRECTIONS.length)];
            BlockPos blockpos = pPos.relative(direction);
            BlockState blockstate = pLevel.getBlockState(blockpos);
            Block block = null;
            if (BuddingQuartziteBlock.canClusterGrowAtState((BlockState)blockstate)) {
                block = (Block)NMLBlocks.SMALL_QUARTZITE_BUD.get();
            } else if (blockstate.is((Block)NMLBlocks.SMALL_QUARTZITE_BUD.get()) && blockstate.getValue((Property)AmethystClusterBlock.FACING) == direction) {
                block = (Block)NMLBlocks.MEDIUM_QUARTZITE_BUD.get();
            } else if (blockstate.is((Block)NMLBlocks.MEDIUM_QUARTZITE_BUD.get()) && blockstate.getValue((Property)AmethystClusterBlock.FACING) == direction) {
                block = (Block)NMLBlocks.LARGE_QUARTZITE_BUD.get();
            } else if (blockstate.is((Block)NMLBlocks.LARGE_QUARTZITE_BUD.get()) && blockstate.getValue((Property)AmethystClusterBlock.FACING) == direction) {
                block = (Block)NMLBlocks.QUARTZITE_CLUSTER.get();
            }
            if (block != null) {
                BlockState blockstate1 = (BlockState)((BlockState)block.defaultBlockState().setValue((Property)AmethystClusterBlock.FACING, (Comparable)direction)).setValue((Property)AmethystClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(blockstate.getFluidState().getType() == Fluids.WATER));
                pLevel.setBlockAndUpdate(blockpos, blockstate1);
            }
        }
    }
}

