/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block;

import com.farcr.nomansland.NMLConfig;
import com.farcr.nomansland.common.integration.Mods;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FrostedGrassBlock
extends BushBlock
implements BonemealableBlock {
    public static final BooleanProperty SNOWLOGGED = BooleanProperty.create((String)"snowlogged");
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    protected static final VoxelShape SNOWLOGGED_SHAPE = Shapes.or((VoxelShape)SHAPE, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0));

    public FrostedGrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SNOWLOGGED, (Comparable)Boolean.FALSE));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.getMainHandItem().is(Blocks.SNOW.asItem()) && !((Boolean)state.getValue((Property)SNOWLOGGED)).booleanValue() && ((Boolean)NMLConfig.GRASS_FROSTING.get()).booleanValue() && !Mods.SNOWREALMAGIC.isLoaded()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SNOWLOGGED, (Comparable)Boolean.valueOf(true)));
            stack.consume(1, (LivingEntity)player);
            level.playSound(player, pos, SoundEvents.SNOW_PLACE, SoundSource.PLAYERS, 1.0f, (level.random.nextFloat() - level.random.nextFloat()) * 0.6f + 1.2f);
            BlockPos posBelow = pos.below();
            BlockState stateUnder = level.getBlockState(posBelow);
            if (stateUnder.getBlock() instanceof SnowyDirtBlock) {
                level.setBlockAndUpdate(posBelow, (BlockState)stateUnder.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(true)));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        if (useContext.getItemInHand().is(Blocks.SNOW.asItem()) || useContext.getItemInHand().is(Blocks.SHORT_GRASS.asItem())) {
            return false;
        }
        return super.canBeReplaced(state, useContext);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)SNOWLOGGED) != false ? SNOWLOGGED_SHAPE : SHAPE;
    }

    protected MapCodec<? extends BushBlock> codec() {
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SNOWLOGGED});
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        int x = blockPos.getX();
        int y = blockPos.getY();
        int z = blockPos.getZ();
        for (BlockPos pos : BlockPos.betweenClosed((int)(x - 3), (int)(y - 1), (int)(z - 3), (int)(x + 3), (int)(y + 2), (int)(z + 3))) {
            if (!(randomSource.nextFloat() < 0.3f) || !blockState.canSurvive((LevelReader)serverLevel, pos) || !serverLevel.isEmptyBlock(pos)) continue;
            serverLevel.setBlockAndUpdate(pos, NMLBlocks.GRASS_SPROUTS.block().defaultBlockState());
        }
    }
}

