/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block;

import com.farcr.nomansland.common.integration.FDIntegration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.block.FeastBlock;

public class StallionStripsBlock
extends FeastBlock {
    public static final IntegerProperty STRIP_SERVINGS = IntegerProperty.create((String)"servings", (int)0, (int)5);
    protected static final VoxelShape PLATE_SHAPE_Z = Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)2.0, (double)15.0);
    protected static final VoxelShape FOOD_SHAPE_Z = Shapes.or((VoxelShape)PLATE_SHAPE_Z, (VoxelShape)Block.box((double)0.0, (double)2.0, (double)1.0, (double)16.0, (double)4.0, (double)15.0));
    protected static final VoxelShape PLATE_SHAPE_X = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)2.0, (double)16.0);
    protected static final VoxelShape FOOD_SHAPE_X = Shapes.or((VoxelShape)PLATE_SHAPE_X, (VoxelShape)Block.box((double)1.0, (double)2.0, (double)0.0, (double)15.0, (double)4.0, (double)16.0));

    public StallionStripsBlock(BlockBehaviour.Properties properties) {
        super(properties, FDIntegration.STALLION_STRIP::item, true);
    }

    public IntegerProperty getServingsProperty() {
        return STRIP_SERVINGS;
    }

    public int getMaxServings() {
        return 5;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean empty = (Integer)state.getValue((Property)this.getServingsProperty()) == 0;
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH, Direction.SOUTH -> {
                if (empty) {
                    yield PLATE_SHAPE_Z;
                }
                yield FOOD_SHAPE_Z;
            }
            default -> empty ? PLATE_SHAPE_X : FOOD_SHAPE_X;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, STRIP_SERVINGS});
    }
}

