/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block;

import com.farcr.nomansland.common.entity.tortoise.Tortoise;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;

public class TortoiseEggBlock
extends Block {
    public static final MapCodec<TortoiseEggBlock> CODEC = TortoiseEggBlock.simpleCodec(TortoiseEggBlock::new);
    private static final VoxelShape ONE_EGG_AABB = Block.box((double)3.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)12.0);
    private static final VoxelShape MULTIPLE_EGGS_AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;
    public static final IntegerProperty EGGS = IntegerProperty.create((String)"eggs", (int)1, (int)3);

    public MapCodec<TortoiseEggBlock> codec() {
        return CODEC;
    }

    public TortoiseEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HATCH, (Comparable)Integer.valueOf(0))).setValue((Property)EGGS, (Comparable)Integer.valueOf(1)));
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.isSteppingCarefully()) {
            this.destroyEgg(level, state, pos, entity, 100);
        }
        super.stepOn(level, pos, state, entity);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!(entity instanceof Zombie)) {
            this.destroyEgg(level, state, pos, entity, 3);
        }
        super.fallOn(level, state, pos, entity, fallDistance);
    }

    private void destroyEgg(Level level, BlockState state, BlockPos pos, Entity entity, int chance) {
        if (this.canDestroyEgg(level, entity) && !level.isClientSide && level.random.nextInt(chance) == 0 && state.is(NMLBlocks.TORTOISE_EGGS)) {
            this.decreaseEggs(level, pos, state);
        }
    }

    private void decreaseEggs(Level level, BlockPos pos, BlockState state) {
        level.playSound(null, pos, SoundEvents.TURTLE_EGG_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + level.random.nextFloat() * 0.2f);
        int i = (Integer)state.getValue((Property)EGGS);
        if (i <= 1) {
            level.destroyBlock(pos, false);
        } else {
            level.setBlock(pos, (BlockState)state.setValue((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((BlockState)state));
            level.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i = (Integer)state.getValue((Property)HATCH);
        if (this.shouldUpdateHatchLevel((Level)level)) {
            if (i < 2) {
                level.playSound(null, pos, SoundEvents.TURTLE_EGG_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                level.setBlock(pos, (BlockState)state.setValue((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
            } else {
                level.playSound(null, pos, SoundEvents.TURTLE_EGG_HATCH, SoundSource.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                level.removeBlock(pos, false);
                level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((BlockState)state));
                for (int j = 0; j < (Integer)state.getValue((Property)EGGS); ++j) {
                    level.levelEvent(2001, pos, Block.getId((BlockState)state));
                    Tortoise tortoise = (Tortoise)NMLEntities.TORTOISE.get().create((Level)level);
                    if (tortoise == null) continue;
                    tortoise.setAge(-432000);
                    tortoise.moveTo((double)pos.getX() + 0.3 + (double)j * 0.2, pos.getY(), (double)pos.getZ() + 0.3, 0.0f, 0.0f);
                    level.addFreshEntity((Entity)tortoise);
                }
            }
        }
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, 2);
        if (!level.isClientSide) {
            level.levelEvent(2012, pos, 15);
        }
    }

    private boolean shouldUpdateHatchLevel(Level level) {
        return level.getRandom().nextInt(25) == 0;
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.playerDestroy(level, player, pos, state, te, stack);
        this.decreaseEggs(level, pos, state);
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return !useContext.isSecondaryUseActive() && useContext.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)EGGS) < 3 ? true : super.canBeReplaced(state, useContext);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        return blockstate.is((Block)this) ? (BlockState)blockstate.setValue((Property)EGGS, (Comparable)Integer.valueOf(Math.min(3, (Integer)blockstate.getValue((Property)EGGS) + 1))) : super.getStateForPlacement(context);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.getValue((Property)EGGS) > 1 ? MULTIPLE_EGGS_AABB : ONE_EGG_AABB;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HATCH, EGGS});
    }

    private boolean canDestroyEgg(Level level, Entity entity) {
        if (entity instanceof Tortoise || entity instanceof Bat) {
            return false;
        }
        return !(entity instanceof LivingEntity) ? false : entity instanceof Player || EventHooks.canEntityGrief((Level)level, (Entity)entity);
    }
}

