/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block.cauldrons;

import com.farcr.nomansland.common.recipe.CauldronInteractionInput;
import com.farcr.nomansland.common.recipe.CauldronInteractionRecipe;
import com.farcr.nomansland.common.registry.NMLRecipeSerializers;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class FourLayeredCauldronBlock
extends AbstractCauldronBlock {
    public static final IntegerProperty LEVEL = IntegerProperty.create((String)"level", (int)1, (int)4);
    public final Supplier<SimpleParticleType> particleType;

    public FourLayeredCauldronBlock(Supplier<SimpleParticleType> particleType) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON), CauldronInteraction.EMPTY);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(1)));
        this.particleType = particleType;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LEVEL});
    }

    protected MapCodec<? extends AbstractCauldronBlock> codec() {
        return null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean interacted = false;
        BlockState newState = null;
        RecipeManager recipes = level.getRecipeManager();
        CauldronInteractionInput input = new CauldronInteractionInput(state, stack);
        Optional optional = recipes.getRecipeFor(NMLRecipeSerializers.CAULDRON_INTERACTION_RECIPE.get(), (RecipeInput)input, level);
        Optional<CauldronInteractionRecipe> recipe = optional.map(RecipeHolder::value);
        ItemStack result = recipe.map(r -> r.assemble(input, (HolderLookup.Provider)level.registryAccess())).orElse(ItemStack.EMPTY);
        int cost = recipe.map(CauldronInteractionRecipe::levelCost).orElse(1);
        if (!result.isEmpty()) {
            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS);
            int i = (Integer)state.getValue((Property)LEVEL) - cost;
            newState = i == 0 ? Blocks.CAULDRON.defaultBlockState() : (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(i));
            level.setBlockAndUpdate(pos, newState);
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)result));
            interacted = true;
        }
        if (interacted) {
            player.awardStat(Stats.USE_CAULDRON);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of(newState));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean isFull(BlockState blockState) {
        return (Integer)blockState.getValue((Property)LEVEL) == 4;
    }

    public void raiseFillLevel(BlockState state, Level level, BlockPos pos) {
        BlockState newState = (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf((Integer)state.getValue((Property)LEVEL) + 1));
        level.setBlockAndUpdate(pos, newState);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
    }

    public static void lowerFillLevel(BlockState state, Level level, BlockPos pos) {
        int i = (Integer)state.getValue((Property)LEVEL) - 1;
        BlockState newState = i == 0 ? Blocks.CAULDRON.defaultBlockState() : (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(i));
        level.setBlockAndUpdate(pos, newState);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (this.isEntityInsideContent(state, pos, entity) && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            RecipeManager recipes = level.getRecipeManager();
            CauldronInteractionInput input = new CauldronInteractionInput(state, itemEntity.getItem());
            Optional optional = recipes.getRecipeFor(NMLRecipeSerializers.CAULDRON_INTERACTION_RECIPE.get(), (RecipeInput)input, level);
            Optional<CauldronInteractionRecipe> recipe = optional.map(RecipeHolder::value);
            ItemStack result = recipe.map(r -> r.assemble(input, (HolderLookup.Provider)level.registryAccess())).orElse(ItemStack.EMPTY);
            int cost = recipe.map(CauldronInteractionRecipe::levelCost).orElse(1);
            if (!result.isEmpty()) {
                itemEntity.discard();
                int i = (Integer)state.getValue((Property)LEVEL) - cost;
                BlockState blockstate = i == 0 ? Blocks.CAULDRON.defaultBlockState() : (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(i));
                level.setBlockAndUpdate(pos, blockstate);
                if (!level.isClientSide()) {
                    ItemEntity newItemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, result);
                    level.addFreshEntity((Entity)newItemEntity);
                }
            }
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return Blocks.CAULDRON.getCloneItemStack(state, target, level, pos, player);
    }

    protected double getContentHeight(BlockState state) {
        return (4.0 + (double)((Integer)state.getValue((Property)LEVEL)).intValue() * 2.75) / 16.0;
    }
}

