/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block.cauldrons;

import com.farcr.nomansland.common.block.cauldrons.FourLayeredCauldronBlock;
import com.farcr.nomansland.common.block.cauldrons.ResinOilCauldron;
import com.farcr.nomansland.common.registry.NMLParticleTypes;
import com.farcr.nomansland.common.registry.NMLSounds;
import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import com.farcr.nomansland.common.registry.items.NMLItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ResinCauldron
extends FourLayeredCauldronBlock {
    public ResinCauldron() {
        super(NMLParticleTypes.RESIN_DROPLET);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        ItemStack containedStack = new ItemStack((ItemLike)NMLItems.RESIN.get(), 2);
        if (!player.getInventory().add(containedStack)) {
            player.drop(containedStack, false);
        }
        ResinCauldron.lowerFillLevel(state, level, pos);
        level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS);
        player.awardStat(Stats.USE_CAULDRON);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean interacted = false;
        if (stack.is(NMLItems.RESIN) && (player.hasInfiniteMaterials() || stack.getCount() >= 2) && !this.isFull(state)) {
            stack.consume(2, (LivingEntity)player);
            interacted = true;
            this.raiseFillLevel(state, level, pos);
            level.playSound(null, pos, (SoundEvent)NMLSounds.RESIN_CONSUMED.get(), SoundSource.BLOCKS);
        }
        if (interacted) {
            player.awardStat(Stats.USE_CAULDRON);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (this.isEntityInsideContent(state, pos, entity)) {
            ItemEntity itemEntity;
            if (entity instanceof LivingEntity && (Integer)state.getValue((Property)LEVEL) > 1) {
                level.playSound(null, pos, (SoundEvent)NMLSounds.STICKY_CAULDRON_SLIDE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                entity.makeStuckInBlock(state, new Vec3(0.9, 0.9, 0.9));
            }
            if (entity instanceof ItemEntity && (itemEntity = (ItemEntity)entity).getItem().is(NMLTags.MAKES_RESIN_OIL) && level.getBlockState(pos.below()).is(NMLTags.HEAT_SOURCES)) {
                entity.remove(Entity.RemovalReason.DISCARDED);
                level.playSound(null, pos, (SoundEvent)NMLSounds.HONEYCOMB_CONSUMED.get(), SoundSource.BLOCKS, 1.0f, 0.5f);
                level.setBlockAndUpdate(pos, ((ResinOilCauldron)((Object)NMLBlocks.RESIN_OIL_CAULDRON.get())).withPropertiesOf(state));
            }
        }
    }
}

