/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block.fruit_trees;

import com.farcr.nomansland.common.block.fruit_trees.FruitBlock;
import com.farcr.nomansland.common.block.fruit_trees.FruitType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FruitLeavesBlock
extends LeavesBlock {
    public Holder<Block> fruit;
    public Holder<Block> leaves;
    public int growthSpeed;

    public FruitLeavesBlock(BlockBehaviour.Properties properties, FruitType fruitType) {
        super(properties);
        this.fruit = fruitType.getFruitBlock();
        this.leaves = fruitType.getLeaves();
        this.growthSpeed = fruitType.getGrowthSpeed();
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.randomTick(state, level, pos, random);
        int fruitLeaves = 0;
        int regularLeaves = 0;
        if (!((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            for (Direction direction : Direction.values()) {
                BlockPos relativePos = pos.relative(direction);
                if (level.getBlockState(relativePos).is((Block)this)) {
                    ++fruitLeaves;
                }
                if (level.getBlockState(relativePos).is(this.leaves)) {
                    ++regularLeaves;
                }
                for (Direction direction1 : Direction.values()) {
                    if (direction1 == direction.getOpposite()) continue;
                    BlockPos relativePos1 = relativePos.relative(direction1);
                    if (level.getBlockState(relativePos1).is((Block)this)) {
                        ++fruitLeaves;
                    }
                    if (!level.getBlockState(relativePos1).is(this.leaves)) continue;
                    ++regularLeaves;
                }
            }
            if (regularLeaves < 4) {
                this.rot((Level)level, pos, state);
            }
            if (fruitLeaves > 4) {
                this.rot((Level)level, pos, state);
            }
        }
        BlockPos fruitPos = pos.below();
        BlockState fruitState = level.getBlockState(fruitPos);
        if (!level.isAreaLoaded(fruitPos, 1)) {
            return;
        }
        if (level.getRawBrightness(fruitPos, 0) >= 9 && random.nextInt(this.growthSpeed, 10) == this.growthSpeed) {
            Direction direction;
            direction = fruitState.getBlock();
            if (direction instanceof FruitBlock) {
                FruitBlock fruitBlock = (FruitBlock)direction;
                int fruitAge = (Integer)fruitState.getValue((Property)FruitBlock.AGE);
                if (fruitAge < fruitBlock.getMaxAge()) {
                    level.setBlockAndUpdate(fruitPos, (BlockState)fruitState.setValue((Property)FruitBlock.AGE, (Comparable)Integer.valueOf(fruitAge + 1)));
                }
            } else if (fruitState.isAir()) {
                level.setBlockAndUpdate(fruitPos, (BlockState)((Block)this.fruit.value()).defaultBlockState().setValue((Property)FruitBlock.AGE, (Comparable)Integer.valueOf(0)));
            }
        }
    }

    public void rot(Level level, BlockPos pos, BlockState state) {
        int distance = (Integer)state.getValue((Property)DISTANCE);
        boolean waterlogged = (Boolean)state.getValue((Property)WATERLOGGED);
        if (level.getBlockState(pos.below()).getBlock() instanceof FruitBlock) {
            level.setBlockAndUpdate(pos.below(), Blocks.AIR.defaultBlockState());
        }
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)((Block)this.leaves.value()).defaultBlockState().setValue((Property)DISTANCE, (Comparable)Integer.valueOf(distance))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)));
    }
}

