/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block.torches;

import com.farcr.nomansland.common.block.torches.ExtinguishedSconceTorchBlock;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SconceTorchBlock
extends TorchBlock {
    protected static final VoxelShape AABB = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);

    public SconceTorchBlock(SimpleParticleType flameParticle, BlockBehaviour.Properties properties) {
        super(flameParticle, properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getY() + 0.8;
        double d2 = (double)pos.getZ() + 0.5;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)this.flameParticle, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    protected void onExplosionHit(BlockState state, Level level, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> dropConsumer) {
        if (explosion.canTriggerBlocks()) {
            level.setBlockAndUpdate(pos, state.is(NMLBlocks.SCONCE_SOUL_TORCH.block()) ? ((ExtinguishedSconceTorchBlock)((Object)NMLBlocks.EXTINGUISHED_SCONCE_SOUL_TORCH.get())).withPropertiesOf(state) : ((ExtinguishedSconceTorchBlock)((Object)NMLBlocks.EXTINGUISHED_SCONCE_TORCH.get())).withPropertiesOf(state));
        }
        super.onExplosionHit(state, level, pos, explosion, dropConsumer);
    }
}

