/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.blockentity;

import com.farcr.nomansland.common.entity.bombs.ThrowableBombEntity;
import com.farcr.nomansland.common.item.ThrowableBombItem;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class BombDispenseBehavior
extends DefaultDispenseItemBehavior {
    private final ThrowableBombItem bombItem;

    public BombDispenseBehavior(Item bomb) {
        ThrowableBombItem throwableBombItem;
        if (!(bomb instanceof ThrowableBombItem)) {
            String name = String.valueOf(bomb);
            throw new IllegalArgumentException(name + " not instance of " + ThrowableBombItem.class.getSimpleName());
        }
        this.bombItem = throwableBombItem = (ThrowableBombItem)bomb;
    }

    public ItemStack execute(BlockSource source, ItemStack stack) {
        ServerLevel level = source.level();
        ProjectileItem.DispenseConfig dispenseConfig = this.bombItem.createDispenseConfig();
        Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        Position position = dispenseConfig.positionFunction().getDispensePosition(source, direction);
        ThrowableBombEntity bombEntity = this.bombItem.asProjectile((Level)level, position, stack, direction);
        bombEntity.shoot(direction.getStepX(), direction.getStepY(), direction.getStepZ(), dispenseConfig.power(), dispenseConfig.uncertainty());
        level.addFreshEntity((Entity)bombEntity);
        stack.shrink(1);
        return stack;
    }

    protected void playSound(BlockSource source) {
        source.level().levelEvent(1002, source.pos(), 0);
    }
}

