/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.effect;

import com.farcr.nomansland.common.registry.NMLCriteriaTriggers;
import com.farcr.nomansland.common.registry.NMLDamageTypes;
import com.farcr.nomansland.common.registry.NMLParticleTypes;
import com.farcr.nomansland.common.registry.NMLTags;
import com.farcr.nomansland.common.registry.entities.NMLEffects;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public class FlammableEffect
extends MobEffect {
    public FlammableEffect(MobEffectCategory category, int color) {
        super(category, color);
        this.particleFactory = mobEffectInstance -> (ParticleOptions)NMLParticleTypes.OIL.get();
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MobEffectInstance flammableEffectInstance = livingEntity.getEffect(NMLEffects.FLAMMABLE);
        if (flammableEffectInstance != null && livingEntity.isInWaterOrRain() && livingEntity instanceof ServerPlayer) {
            int durationLost;
            livingEntity.removeEffect(NMLEffects.FLAMMABLE);
            int n = durationLost = livingEntity.isUnderWater() ? 4 : 2;
            if (flammableEffectInstance.getDuration() > durationLost) {
                livingEntity.addEffect(new MobEffectInstance(NMLEffects.FLAMMABLE, flammableEffectInstance.getDuration() - durationLost, flammableEffectInstance.getAmplifier()));
            }
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public void onMobHurt(LivingEntity livingEntity, int amplifier, DamageSource damageSource, float amount) {
        Level level = livingEntity.level();
        MobEffectInstance flammableEffectInstance = livingEntity.getEffect(NMLEffects.FLAMMABLE);
        if (flammableEffectInstance != null && (damageSource.is(NMLTags.IGNITES_FLAMMABLE) || damageSource.getWeaponItem() != null && damageSource.getWeaponItem().is(NMLTags.FIRESTARTERS))) {
            Entity entity2 = damageSource.getEntity();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity2;
                ((KilledTrigger)NMLCriteriaTriggers.IGNITE_FLAMMABLE_ENTITY.get()).trigger(serverPlayer, (Entity)livingEntity, damageSource);
            }
            livingEntity.hurt(NMLDamageTypes.getSimpleDamageSource(level, NMLDamageTypes.COMBUST), (float)(6 + amplifier * 4));
            livingEntity.setRemainingFireTicks(livingEntity.getRemainingFireTicks() + flammableEffectInstance.getDuration());
            livingEntity.removeEffect(NMLEffects.FLAMMABLE);
            FireBlock delegate = (FireBlock)Blocks.FIRE;
            if (level.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
                AABB boundingBox = livingEntity.getBoundingBox().inflate(1.5, 0.0, 1.5);
                ArrayList positions = BlockPos.betweenClosedStream((AABB)boundingBox).map(BlockPos::immutable).distinct().collect(Collectors.toCollection(ArrayList::new));
                level.getEntities(EntityTypeTest.forClass(LivingEntity.class), boundingBox, entity -> entity.hasEffect(NMLEffects.FLAMMABLE)).forEach(entity -> {
                    entity.hurt(entity.damageSources().onFire(), 2.0f);
                    entity.setRemainingFireTicks(100);
                });
                for (BlockPos pos : positions) {
                    if ((double)level.random.nextFloat() < 0.8 || level.isRaining() && delegate.isNearRain(level, pos)) continue;
                    for (Direction d : Direction.values()) {
                        if (level.getBlockState(pos.below()).isFlammable((BlockGetter)level, pos.below(), d) && level.getBlockState(pos.below()).canBeReplaced()) {
                            pos = pos.below();
                            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                        }
                        if (!BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)pos, (Direction)d)) continue;
                        BlockState state = BaseFireBlock.getState((BlockGetter)level, (BlockPos)pos);
                        level.setBlock(pos, state, 3);
                    }
                }
                level.playSound(null, livingEntity.blockPosition(), SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS);
            }
        }
        super.onMobHurt(livingEntity, amplifier, damageSource, amount);
    }
}

