/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity;

import com.farcr.nomansland.common.registry.entities.NMLEntities;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public class LingeringCloud
extends Entity
implements TraceableEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TIME_BETWEEN_APPLICATIONS = 5;
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.defineId(LingeringCloud.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> DATA_WAITING = SynchedEntityData.defineId(LingeringCloud.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<ParticleOptions> DATA_PARTICLE = SynchedEntityData.defineId(LingeringCloud.class, (EntityDataSerializer)EntityDataSerializers.PARTICLE);
    private static final float MAX_RADIUS = 32.0f;
    private static final float MINIMAL_RADIUS = 0.5f;
    private static final float DEFAULT_RADIUS = 3.0f;
    public static final float DEFAULT_WIDTH = 6.0f;
    public static final float HEIGHT = 0.5f;
    private PotionContents potionContents = PotionContents.EMPTY;
    protected final Map<LivingEntity, Integer> victims = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public LingeringCloud(EntityType<? extends LingeringCloud> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    public LingeringCloud(Level level, double x, double y, double z) {
        this(NMLEntities.LINGERING_CLOUD.get(), level);
        this.setPos(x, y, z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_RADIUS, (Object)Float.valueOf(3.0f));
        builder.define(DATA_WAITING, (Object)false);
        builder.define(DATA_PARTICLE, (Object)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-1));
    }

    public void setRadius(float radius) {
        if (!this.level().isClientSide) {
            this.getEntityData().set(DATA_RADIUS, (Object)Float.valueOf(Mth.clamp((float)radius, (float)0.0f, (float)32.0f)));
        }
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    public float getRadius() {
        return ((Float)this.getEntityData().get(DATA_RADIUS)).floatValue();
    }

    public void setPotionContents(PotionContents potionContents) {
        this.potionContents = potionContents;
        this.updateColor();
    }

    private void updateColor() {
        ParticleOptions particleoptions = (ParticleOptions)this.entityData.get(DATA_PARTICLE);
        if (particleoptions instanceof ColorParticleOption) {
            ColorParticleOption colorparticleoption = (ColorParticleOption)particleoptions;
            int i = this.potionContents.equals((Object)PotionContents.EMPTY) ? 0 : this.potionContents.getColor();
            this.entityData.set(DATA_PARTICLE, (Object)ColorParticleOption.create((ParticleType)colorparticleoption.getType(), (int)FastColor.ARGB32.opaque((int)i)));
        }
    }

    public void tick() {
        block20: {
            boolean shouldBeWaiting;
            double centerY;
            float radius;
            boolean isWaiting;
            Level level;
            block19: {
                super.tick();
                level = this.level();
                isWaiting = this.isWaiting();
                radius = this.getRadius();
                centerY = this.getY() + (double)this.getBbHeight() / 2.0;
                if (!level.isClientSide) break block19;
                if (isWaiting && this.random.nextBoolean()) {
                    return;
                }
                ParticleOptions particle = this.getParticle((LevelAccessor)level);
                int count = isWaiting ? 2 : Mth.ceil((double)(Math.PI * (double)radius * (double)radius));
                float spread = isWaiting ? 0.2f : radius;
                for (int i = 0; i < count; ++i) {
                    double theta = this.random.nextDouble() * 6.2831854820251465;
                    double phi = Math.acos(2.0 * this.random.nextDouble() - 1.0);
                    double r = (double)spread * Math.cbrt(this.random.nextDouble());
                    double sinPhi = Math.sin(phi);
                    double x = this.getX() + r * sinPhi * Math.cos(theta);
                    double y = centerY + r * Math.cos(phi);
                    double z = this.getZ() + r * sinPhi * Math.sin(theta);
                    if (particle.getType() == ParticleTypes.ENTITY_EFFECT) {
                        if (isWaiting && this.random.nextBoolean()) {
                            level.addAlwaysVisibleParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-1), x, y, z, 0.0, 0.0, 0.0);
                            continue;
                        }
                        level.addAlwaysVisibleParticle(particle, x, y, z, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (isWaiting) {
                        level.addAlwaysVisibleParticle(particle, x, y, z, 0.0, 0.0, 0.0);
                        continue;
                    }
                    level.addAlwaysVisibleParticle(particle, x, y, z, (0.5 - this.random.nextDouble()) * 0.15, 0.01, (0.5 - this.random.nextDouble()) * 0.15);
                }
                break block20;
            }
            if (this.tickCount >= this.waitTime + this.duration) {
                this.discard();
                return;
            }
            boolean bl = shouldBeWaiting = this.tickCount < this.waitTime;
            if (isWaiting != shouldBeWaiting) {
                this.setWaiting(shouldBeWaiting);
            }
            if (shouldBeWaiting) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((radius += this.radiusPerTick) < 0.2f) {
                    this.discard();
                    return;
                }
                this.setRadius(radius);
            }
            if (this.tickCount % 5 != 0) break block20;
            this.victims.entrySet().removeIf(entry -> this.tickCount >= (Integer)entry.getValue());
            if (!this.potionContents.hasEffects()) {
                this.victims.clear();
            } else {
                ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
                if (this.potionContents.potion().isPresent()) {
                    for (MobEffectInstance effect : ((Potion)((Holder)this.potionContents.potion().get()).value()).getEffects()) {
                        effects.add(new MobEffectInstance(effect.getEffect(), effect.mapDuration(d -> d / 4), effect.getAmplifier(), effect.isAmbient(), effect.isVisible()));
                    }
                }
                effects.addAll(this.potionContents.customEffects());
                AABB area = new AABB(this.getX() - (double)radius, centerY - (double)radius, this.getZ() - (double)radius, this.getX() + (double)radius, centerY + (double)radius, this.getZ() + (double)radius);
                List entities = level.getEntitiesOfClass(LivingEntity.class, area);
                for (LivingEntity entity : entities) {
                    double dz;
                    double dy;
                    double dx;
                    double distSq;
                    if (this.victims.containsKey(entity) || !entity.isAffectedByPotions() || effects.stream().noneMatch(arg_0 -> ((LivingEntity)entity).canBeAffected(arg_0)) || (distSq = (dx = this.getX() - entity.getX()) * dx + (dy = centerY - entity.getY()) * dy + (dz = this.getZ() - entity.getZ()) * dz) > (double)(radius * radius)) continue;
                    this.victims.put(entity, this.tickCount + this.reapplicationDelay);
                    double distance = Math.sqrt(distSq);
                    double proximity = 1.0 - distance / (double)radius;
                    proximity = Mth.clamp((double)proximity, (double)0.0, (double)1.0);
                    for (MobEffectInstance effect : effects) {
                        if (((MobEffect)effect.getEffect().value()).isInstantenous()) {
                            ((MobEffect)effect.getEffect().value()).applyInstantenousEffect((Entity)this, (Entity)this.getOwner(), entity, effect.getAmplifier(), 0.5);
                            continue;
                        }
                        int scaledDuration = (int)Math.max((double)effect.getDuration() * 0.5, (double)effect.getDuration() * proximity);
                        MobEffectInstance scaled = new MobEffectInstance(effect.getEffect(), scaledDuration, effect.getAmplifier(), effect.isAmbient(), effect.isVisible(), effect.showIcon());
                        entity.addEffect(scaled, (Entity)this);
                    }
                    if (this.radiusOnUse != 0.0f) {
                        if ((radius += this.radiusOnUse) < 0.5f) {
                            this.discard();
                            return;
                        }
                        this.setRadius(radius);
                    }
                    if (this.durationOnUse == 0) continue;
                    this.duration += this.durationOnUse;
                    if (this.duration > 0) continue;
                    this.discard();
                    return;
                }
            }
        }
    }

    public void addEffect(MobEffectInstance effectInstance) {
        this.setPotionContents(this.potionContents.withEffectAdded(effectInstance));
    }

    public ParticleOptions getParticle(LevelAccessor levelAccessor) {
        return this.getParticle();
    }

    public ParticleOptions getParticle() {
        return (ParticleOptions)this.getEntityData().get(DATA_PARTICLE);
    }

    public void setParticle(ParticleOptions particleOption) {
        this.getEntityData().set(DATA_PARTICLE, (Object)particleOption);
    }

    protected void setWaiting(boolean waiting) {
        this.getEntityData().set(DATA_WAITING, (Object)waiting);
    }

    public boolean isWaiting() {
        return (Boolean)this.getEntityData().get(DATA_WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float radiusOnUse) {
        this.radiusOnUse = radiusOnUse;
    }

    public float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public void setRadiusPerTick(float radiusPerTick) {
        this.radiusPerTick = radiusPerTick;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int durationOnUse) {
        this.durationOnUse = durationOnUse;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUUID = owner == null ? null : owner.getUUID();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.tickCount = compound.getInt("Age");
        this.duration = compound.getInt("Duration");
        this.waitTime = compound.getInt("WaitTime");
        this.reapplicationDelay = compound.getInt("ReapplicationDelay");
        this.durationOnUse = compound.getInt("DurationOnUse");
        this.radiusOnUse = compound.getFloat("RadiusOnUse");
        this.radiusPerTick = compound.getFloat("RadiusPerTick");
        this.setRadius(compound.getFloat("Radius"));
        if (compound.hasUUID("Owner")) {
            this.ownerUUID = compound.getUUID("Owner");
        }
        RegistryOps registryops = this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (compound.contains("Particle", 10)) {
            ParticleTypes.CODEC.parse((DynamicOps)registryops, (Object)compound.get("Particle")).resultOrPartial(p -> LOGGER.warn("Failed to parse area effect cloud particle options: '{}'", p)).ifPresent(this::setParticle);
        }
        if (compound.contains("potion_contents")) {
            PotionContents.CODEC.parse((DynamicOps)registryops, (Object)compound.get("potion_contents")).resultOrPartial(p -> LOGGER.warn("Failed to parse area effect cloud potions: '{}'", p)).ifPresent(this::setPotionContents);
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Age", this.tickCount);
        compound.putInt("Duration", this.duration);
        compound.putInt("WaitTime", this.waitTime);
        compound.putInt("ReapplicationDelay", this.reapplicationDelay);
        compound.putInt("DurationOnUse", this.durationOnUse);
        compound.putFloat("RadiusOnUse", this.radiusOnUse);
        compound.putFloat("RadiusPerTick", this.radiusPerTick);
        compound.putFloat("Radius", this.getRadius());
        RegistryOps registryops = this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        compound.put("Particle", (Tag)ParticleTypes.CODEC.encodeStart((DynamicOps)registryops, (Object)this.getParticle()).getOrThrow());
        if (this.ownerUUID != null) {
            compound.putUUID("Owner", this.ownerUUID);
        }
        if (!this.potionContents.equals((Object)PotionContents.EMPTY)) {
            Tag tag = (Tag)PotionContents.CODEC.encodeStart((DynamicOps)registryops, (Object)this.potionContents).getOrThrow();
            compound.put("potion_contents", tag);
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (DATA_RADIUS.equals(key)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.scalable((float)(this.getRadius() * 2.0f), (float)(this.getRadius() * 2.0f));
    }
}

