/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.ai;

import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class MaintainChaseWithinRange
extends Behavior<Mob> {
    private final double maxRange;
    private final MemoryModuleType<LivingEntity> memory;

    public MaintainChaseWithinRange(MemoryModuleType<LivingEntity> memory, double maxRange) {
        super(Map.of(memory, MemoryStatus.VALUE_PRESENT));
        this.memory = memory;
        this.maxRange = maxRange;
    }

    protected void tick(ServerLevel level, Mob mob, long gameTime) {
        Brain brain = mob.getBrain();
        brain.getMemory(this.memory).ifPresent(target -> {
            if (mob.distanceToSqr((Entity)target) > Mth.square((double)this.maxRange)) {
                brain.eraseMemory(MemoryModuleType.ATTACK_TARGET);
                brain.eraseMemory(MemoryModuleType.WALK_TARGET);
                brain.eraseMemory(MemoryModuleType.PATH);
                mob.setTarget(null);
            }
        });
    }
}

