/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.ai;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;

public class WarningAttack {
    public static OneShot<Mob> create(int cooldownBetweenAttacks) {
        return BehaviorBuilder.create(instance -> instance.group((App)instance.registered(MemoryModuleType.LOOK_TARGET), (App)instance.present(MemoryModuleType.NEAREST_ATTACKABLE), (App)instance.absent(MemoryModuleType.ATTACK_COOLING_DOWN), (App)instance.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)instance, (muPositionTrackerMemoryAccessor, muLivingEntityMemoryAccessor, muBooleanMemoryAccessor, nearestVisibleLivingEntities) -> (serverLevel, mob, p_258541_) -> {
            LivingEntity livingentity = (LivingEntity)instance.get(muLivingEntityMemoryAccessor);
            if (!WarningAttack.isHoldingUsableProjectileWeapon(mob) && mob.isWithinMeleeAttackRange(livingentity) && ((NearestVisibleLivingEntities)instance.get(nearestVisibleLivingEntities)).contains(livingentity)) {
                muPositionTrackerMemoryAccessor.set((Object)new EntityTracker((Entity)livingentity, true));
                mob.swing(InteractionHand.MAIN_HAND);
                mob.doHurtTarget((Entity)livingentity);
                muBooleanMemoryAccessor.setWithExpiry((Object)true, (long)cooldownBetweenAttacks);
                return true;
            }
            return false;
        }));
    }

    private static boolean isHoldingUsableProjectileWeapon(Mob mob) {
        return mob.isHolding(stack -> {
            Item item = stack.getItem();
            return item instanceof ProjectileWeaponItem && mob.canFireProjectileWeapon((ProjectileWeaponItem)item);
        });
    }
}

