/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.goose;

import com.farcr.nomansland.common.entity.goose.GooseAI;
import com.farcr.nomansland.common.registry.NMLSounds;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import com.farcr.nomansland.common.registry.entities.NMLEntityDataSerializers;
import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class Goose
extends Animal {
    private static final EntityDataAccessor<State> DATA_STATE = SynchedEntityData.defineId(Goose.class, NMLEntityDataSerializers.GOOSE_STATE.get());
    private int hurtAnimationTick = 0;
    public final AnimationState hurtingAnimationState = new AnimationState();
    public final AnimationState fallingAnimationState = new AnimationState();
    public final AnimationState intimidatingAnimationState = new AnimationState();

    public Goose(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    public static boolean checkGooseSpawnRules(EntityType<? extends Animal> animal, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        boolean flag = Goose.isBrightEnoughToSpawn((BlockAndTintGetter)level, (BlockPos)pos);
        return level.getBlockState(pos.above()).isAir() && flag;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)NMLEntities.GOOSE.get().create((Level)serverLevel);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_STATE, (Object)State.IDLING);
        super.defineSynchedData(builder);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(Items.PUMPKIN_SEEDS);
    }

    public void setInLove(@Nullable Player player) {
        super.setInLove(player);
        if (player != null) {
            this.getBrain().getMemory(MemoryModuleType.ANGRY_AT).ifPresent(angryAt -> {
                if (angryAt == player.getUUID()) {
                    this.getBrain().eraseMemory(MemoryModuleType.ANGRY_AT);
                }
            });
            this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).ifPresent(target -> {
                if (target == player) {
                    this.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
                    this.setTarget(null);
                }
            });
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (DATA_STATE.equals(key)) {
            this.resetAnimations();
            if (this.getState() == State.INTIMIDATING) {
                this.intimidatingAnimationState.startIfStopped(this.tickCount);
            }
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    private void resetAnimations() {
        this.intimidatingAnimationState.stop();
    }

    public State getState() {
        return (State)((Object)this.entityData.get(DATA_STATE));
    }

    public boolean showWings() {
        return this.getState() != State.IDLING || this.hurtingAnimationState.isStarted() || this.fallingAnimationState.isStarted();
    }

    public void setState(State state) {
        this.entityData.set(DATA_STATE, (Object)state);
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    protected Brain.Provider<Goose> brainProvider() {
        return GooseAI.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return GooseAI.makeBrain((Brain<Goose>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Goose> getBrain() {
        return super.getBrain();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)NMLSounds.GOOSE_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)NMLSounds.GOOSE_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)NMLSounds.GOOSE_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
        this.playSound((SoundEvent)NMLSounds.GOOSE_STEP.get(), 0.15f, 1.0f);
    }

    public boolean canFight() {
        return !this.isBaby() && this.getHealth() > this.getMaxHealth() / 2.0f;
    }

    protected void customServerAiStep() {
        ServerLevel level = (ServerLevel)this.level();
        level.getProfiler().push("gooseBrain");
        this.getBrain().tick(level, (LivingEntity)this);
        level.getProfiler().pop();
        level.getProfiler().push("gooseActivityUpdate");
        GooseAI.updateActivity(this);
        level.getProfiler().pop();
        super.customServerAiStep();
    }

    public void aiStep() {
        super.aiStep();
        Vec3 vec3 = this.getDeltaMovement();
        if (!this.onGround() && vec3.y < 0.0) {
            this.setDeltaMovement(vec3.multiply(1.0, 0.6, 1.0));
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.hurtingAnimationState.start(this.tickCount);
            this.hurtAnimationTick = 22;
        }
        super.handleEntityEvent(id);
    }

    public boolean hurt(DamageSource source, float amount) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.hurt(source, amount);
    }

    public void tick() {
        super.tick();
        if (this.onGround() || this.getDeltaMovement().y > 0.0) {
            this.fallingAnimationState.ifStarted(AnimationState::stop);
        } else {
            this.fallingAnimationState.startIfStopped(this.tickCount);
        }
        if (this.hurtAnimationTick > 0) {
            --this.hurtAnimationTick;
        } else {
            this.hurtingAnimationState.ifStarted(AnimationState::stop);
        }
        this.floatGoose();
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return level.getFluidState(pos).is(FluidTags.WATER) ? 5.0f : level.getPathfindingCostFromLightLevels(pos);
    }

    public boolean canStandOnFluid(FluidState fluidState) {
        return fluidState.is(FluidTags.WATER);
    }

    private void floatGoose() {
        if (this.isInWater()) {
            CollisionContext collisioncontext = CollisionContext.of((Entity)this);
            if (collisioncontext.isAbove(LiquidBlock.STABLE_SHAPE, this.blockPosition(), true) && !this.level().getFluidState(this.blockPosition().above()).is(FluidTags.WATER)) {
                if (this.random.nextFloat() < 0.2f) {
                    this.setDeltaMovement(this.getDeltaMovement().scale(0.5).add(0.0, 0.05, 0.0));
                } else {
                    this.setOnGround(true);
                }
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5).add(0.0, 0.05, 0.0));
            }
        }
    }

    protected PathNavigation createNavigation(Level level) {
        return new GoosePathNavigation(this, level);
    }

    public PathNavigation getNavigation() {
        return super.getNavigation();
    }

    public static enum State {
        IDLING(0),
        INTIMIDATING(1),
        RUNNING(2);

        public static final IntFunction<State> BY_ID;
        public static final StreamCodec<ByteBuf, State> STREAM_CODEC;
        private final int id;

        private State(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        static {
            BY_ID = ByIdMap.continuous(State::id, (Object[])State.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, State::id);
        }
    }

    public static class GoosePathNavigation
    extends GroundPathNavigation {
        GoosePathNavigation(Goose goose, Level level) {
            super((Mob)goose, level);
        }

        protected PathFinder createPathFinder(int maxVisitedNodes) {
            this.nodeEvaluator = new WalkNodeEvaluator();
            this.nodeEvaluator.setCanPassDoors(true);
            return new PathFinder(this.nodeEvaluator, maxVisitedNodes);
        }

        protected boolean hasValidPathType(PathType pathType) {
            return pathType == PathType.WATER || super.hasValidPathType(pathType);
        }

        public boolean isStableDestination(BlockPos pos) {
            return this.level.getBlockState(pos).is(Blocks.WATER) || super.isStableDestination(pos);
        }
    }
}

