/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.goose;

import com.farcr.nomansland.common.entity.ai.LeapAtTargetBehavior;
import com.farcr.nomansland.common.entity.goose.Goose;
import com.farcr.nomansland.common.entity.goose.GooseCoreBehavior;
import com.farcr.nomansland.common.registry.entities.NMLEntities;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;

public class GooseAI {
    private static final ImmutableList<SensorType<? extends Sensor<? super Goose>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.IS_IN_WATER, (Object)SensorType.NEAREST_ADULT);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ANGRY_AT, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.NEAREST_PLAYERS, (Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryModuleType.AVOID_TARGET, (Object[])new MemoryModuleType[]{MemoryModuleType.BREED_TARGET, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.IS_PANICKING});

    public static Brain.Provider<Goose> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected static Brain<?> makeBrain(Brain<Goose> brain) {
        GooseAI.initCoreActivity(brain);
        GooseAI.initIdleActivity(brain);
        GooseAI.initFightActivity(brain);
        GooseAI.initAvoidActivity(brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    public static void updateActivity(Goose goose) {
        goose.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.AVOID, (Object)Activity.FIGHT, (Object)Activity.IDLE));
    }

    private static void initCoreActivity(Brain<Goose> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)((Object)new GooseCoreBehavior())));
    }

    private static void initIdleActivity(Brain<Goose> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new AnimalMakeLove(NMLEntities.GOOSE.get(), 1.0f, 1)), (Object)Pair.of((Object)1, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)2, (Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)3, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))));
    }

    private static void initFightActivity(Brain<Goose> brain) {
        brain.addActivityWithConditions(Activity.FIGHT, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new LeapAtTargetBehavior((MemoryModuleType<LivingEntity>)MemoryModuleType.ATTACK_TARGET))), (Object)Pair.of((Object)1, (Object)MeleeAttack.create((int)15)), (Object)Pair.of((Object)2, (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.3f)), (Object)Pair.of((Object)3, (Object)StopAttackingIfTargetInvalid.create())), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void initAvoidActivity(Brain<Goose> brain) {
        brain.addActivityWithConditions(Activity.AVOID, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.3f, (int)8, (boolean)true))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.AVOID_TARGET, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    public static boolean isThreat(LivingEntity entity) {
        return entity.canBeSeenAsEnemy() && (entity instanceof Monster || entity instanceof Player);
    }
}

