/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.moose;

import com.farcr.nomansland.common.entity.ai.MaintainChaseWithinRange;
import com.farcr.nomansland.common.entity.ai.StartChasingWhenHurt;
import com.farcr.nomansland.common.entity.ai.WarningAttack;
import com.farcr.nomansland.common.entity.moose.Charge;
import com.farcr.nomansland.common.entity.moose.Moose;
import com.farcr.nomansland.common.entity.moose.ShakeOffSaddle;
import com.farcr.nomansland.common.entity.moose.Stomp;
import com.farcr.nomansland.common.registry.entities.NMLSensors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class MooseAI {
    private static final ImmutableList<SensorType<? extends Sensor<? super Moose>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, NMLSensors.MOOSE_THREATS.get());
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ANGRY_AT, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.IS_PANICKING);

    public static Brain.Provider<Moose> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<Moose> brain) {
        MooseAI.initCoreActivity(brain);
        MooseAI.initIdleActivity(brain);
        MooseAI.initAvoidActivity(brain);
        MooseAI.initFightActivity(brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    public static void updateActivity(Moose moose) {
        moose.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.AVOID, (Object)Activity.FIGHT, (Object)Activity.IDLE));
    }

    private static void initCoreActivity(Brain<Moose> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), new StartChasingWhenHurt(), (Object)StartAttacking.create(MooseAI::findNearestValidAttackTarget)));
    }

    private static void initIdleActivity(Brain<Moose> brain) {
        brain.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)2, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)((Object)new ShakeOffSaddle()), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initAvoidActivity(Brain<Moose> brain) {
        brain.addActivityWithConditions(Activity.AVOID, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new Stomp())), (Object)Pair.of((Object)1, (Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.NEAREST_ATTACKABLE, (float)1.3f, (int)10, (boolean)false)), (Object)Pair.of((Object)2, WarningAttack.create(80)), (Object)Pair.of((Object)3, (Object)((Object)new Charge()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initFightActivity(Brain<Moose> brain) {
        brain.addActivityWithConditions(Activity.FIGHT, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new MaintainChaseWithinRange((MemoryModuleType<LivingEntity>)MemoryModuleType.ATTACK_TARGET, 10.0))), (Object)Pair.of((Object)1, (Object)MeleeAttack.create((int)40)), (Object)Pair.of((Object)2, (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.7f))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Moose moose) {
        Brain<Moose> brain = moose.getBrain();
        Optional angerTarget = brain.getMemory(MemoryModuleType.ANGRY_AT);
        NearestVisibleLivingEntities entities = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
        return angerTarget.flatMap(uuid -> entities.findClosest(entity -> moose.distanceToSqr((Entity)entity) < (double)Mth.square((int)10) && entity.getUUID() == uuid));
    }
}

