/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.entity.tortoise.ai;

import com.farcr.nomansland.common.entity.tortoise.Tortoise;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class TortoiseSearchForDangerGoal
extends Goal {
    private final Tortoise tortoise;

    public TortoiseSearchForDangerGoal(Tortoise tortoise) {
        this.tortoise = tortoise;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        long gameTime = this.tortoise.level().getGameTime();
        return this.tortoise.inShell() && gameTime - this.tortoise.getHurtWhen() > 700L && this.tortoise.getLastHurtByUUID() != null;
    }

    public void start() {
        super.start();
        List entityList = this.tortoise.level().getEntities((Entity)this.tortoise, this.tortoise.getBoundingBox().inflate(10.0), entity -> this.tortoise.getLastHurtByUUID() != null && this.tortoise.getLastHurtByUUID() == entity.getUUID());
        if (!entityList.isEmpty()) {
            this.tortoise.setHurtWhen(this.tortoise.level().getGameTime());
            this.tortoise.retreatShell(true);
            this.tortoise.setSearching(false);
        } else {
            this.tortoise.retreatShell(false);
            this.tortoise.setSearching(false);
            this.tortoise.setLastHurtByUUID(null);
        }
    }
}

