/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.event;

import com.farcr.nomansland.common.block.CutSugarCaneBlock;
import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="nomansland")
public class BoneMealingEvents {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (event.getFace() != Direction.DOWN && stack.is(Items.SHEARS) && state.is(Blocks.SUGAR_CANE) && !player.isSpectator()) {
            level.playSound(player, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide()) {
                stack.hurtAndBreak(1, (LivingEntity)player, stack.getEquipmentSlot());
                level.setBlockAndUpdate(pos, ((CutSugarCaneBlock)((Object)NMLBlocks.CUT_SUGAR_CANE.get())).defaultBlockState());
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
            event.setCanceled(true);
        }
        if (stack.is(Items.SHEARS) && state.is(Blocks.VINE) && !player.isSpectator()) {
            level.playSound(player, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.isClientSide()) {
                stack.hurtAndBreak(1, (LivingEntity)player, stack.getEquipmentSlot());
                level.setBlockAndUpdate(pos, ((VineBlock)NMLBlocks.CUT_VINE.get()).withPropertiesOf(state));
            }
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
            event.setCanceled(true);
        }
        if (stack.is(Items.BONE_MEAL) && !player.isSpectator() && state.is(Blocks.DIRT) && !level.getBlockState(pos.above()).isSolid()) {
            for (Direction d : Direction.values()) {
                for (Direction d1 : Direction.values()) {
                    if (d == d1) break;
                    BlockPos newBlockPos = pos.relative(d);
                    if (level.getBlockState(newBlockPos).getBlock() instanceof SpreadingSnowyDirtBlock) {
                        if (!player.isCreative()) {
                            stack.shrink(1);
                        }
                        BoneMealingEvents.bonemealDirt(level, pos, level.getBlockState(newBlockPos));
                        level.playSound(player, pos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                        event.setCanceled(true);
                        return;
                    }
                    if (!(level.getBlockState(newBlockPos.relative(d1)).getBlock() instanceof SpreadingSnowyDirtBlock)) continue;
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    BoneMealingEvents.bonemealDirt(level, pos, level.getBlockState(newBlockPos.relative(d1)));
                    level.playSound(player, pos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    public static void bonemealDirt(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide) {
            level.setBlockAndUpdate(pos, state);
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        for (BlockPos bp : BlockPos.betweenClosed((int)(x - 3), (int)(y - 1), (int)(z - 3), (int)(x + 3), (int)(y + 2), (int)(z + 3))) {
            BlockState block = level.getBlockState(bp);
            for (Direction d : Direction.values()) {
                Block newBlock = level.getBlockState(bp.relative(d)).getBlock();
                if (!(level.random.nextFloat() < 0.3f) || block != Blocks.DIRT.defaultBlockState() || !(newBlock instanceof SpreadingSnowyDirtBlock) || level.getBlockState(bp.above()).isSolid()) continue;
                BlockPos particlePosition = bp.above();
                if (!level.isClientSide) {
                    level.setBlockAndUpdate(bp, state);
                }
                BoneMealingEvents.spawnParticles(level, particlePosition);
            }
        }
    }

    public static void spawnParticles(Level level, BlockPos pos) {
        for (int i = 0; i <= 3; ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.COMPOSTER, (double)((float)pos.getX() + level.random.nextFloat() - level.random.nextFloat()), (double)pos.getY() + 0.2 + (double)level.random.nextFloat() - (double)level.random.nextFloat(), (double)((float)pos.getZ() + level.random.nextFloat() - level.random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }
}

