/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.item;

import com.farcr.nomansland.common.entity.bombs.InkBomb;
import com.farcr.nomansland.common.entity.bombs.ThrowableBombEntity;
import com.farcr.nomansland.common.item.ThrowableBombItem;
import com.farcr.nomansland.common.registry.NMLSounds;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class InkBombItem
extends ThrowableBombItem {
    public InkBombItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ThrowableBombEntity asProjectile(Level level, Position position, ItemStack itemStack, Direction direction) {
        return new InkBomb(level, position.x(), position.y(), position.z());
    }

    @Override
    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingTicks) {
        super.onUseTick(level, entity, stack, remainingTicks);
        int timeUsed = this.getUseDuration(stack, entity) - remainingTicks;
        if (timeUsed == 10 && entity.isShiftKeyDown()) {
            entity.playSound((SoundEvent)NMLSounds.BOMB_PRIMED.get());
        }
    }
}

