/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.mixin;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.AlterGroundDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.AlterGroundEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AlterGroundDecorator.class})
public class AlterGroundDecoratorMixin {
    @Shadow
    @Final
    private BlockStateProvider provider;

    @Inject(method={"place"}, at={@At(value="HEAD")}, cancellable=true)
    private void place(TreeDecorator.Context context, CallbackInfo ci) {
        ArrayList startPositions = Lists.newArrayList();
        ObjectArrayList roots = context.roots();
        ObjectArrayList logs = context.logs();
        if (roots.isEmpty()) {
            startPositions.addAll(logs);
        } else if (!logs.isEmpty() && ((BlockPos)roots.getFirst()).getY() == ((BlockPos)logs.getFirst()).getY()) {
            startPositions.addAll(logs);
            startPositions.addAll(roots);
        } else {
            startPositions.addAll(roots);
        }
        if (!startPositions.isEmpty()) {
            BlockStateProvider provider = this.provider;
            AlterGroundEvent.StateProvider eventProvider = EventHooks.alterGround((TreeDecorator.Context)context, (List)startPositions, (arg_0, arg_1) -> ((BlockStateProvider)provider).getState(arg_0, arg_1));
            int maxDistance = 6;
            int maxSpread = 200;
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            LinkedList<Pair> queue = new LinkedList<Pair>();
            for (BlockPos root : startPositions) {
                queue.add(Pair.of((Object)root, (Object)0));
                visited.add(root);
            }
            int spreadCount = 0;
            RandomSource random = context.random();
            while (!queue.isEmpty() && spreadCount < maxSpread) {
                Pair pair = (Pair)queue.poll();
                BlockPos current = (BlockPos)pair.getFirst();
                int distance = (Integer)pair.getSecond();
                if (distance > maxDistance || !Feature.isGrassOrDirt((LevelSimulatedReader)context.level(), (BlockPos)current)) continue;
                context.setBlock(current, eventProvider.getState(random, current));
                ++spreadCount;
                for (Direction direction : Direction.values()) {
                    BlockPos neighbor = current.relative(direction);
                    if (visited.contains(neighbor) || !Feature.isGrassOrDirt((LevelSimulatedReader)context.level(), (BlockPos)neighbor) || !(random.nextFloat() < 0.8f)) continue;
                    visited.add(neighbor);
                    queue.add(Pair.of((Object)neighbor, (Object)(distance + 1)));
                }
            }
        }
        ci.cancel();
    }
}

