/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.mixin;

import com.farcr.nomansland.NMLConfig;
import com.farcr.nomansland.common.mixin.BlockBehaviourMixin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BaseRailBlock.class})
public abstract class BaseRailBlockMixin
extends BlockBehaviourMixin {
    @Shadow
    @Deprecated
    public abstract Property<RailShape> getShapeProperty();

    @Shadow
    protected abstract VoxelShape getShape(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);

    @Unique
    private static boolean nml$floatingRails(BlockPos pos, LevelReader level, RailShape shape, Direction direction) {
        for (int i = 1; i <= (Integer)NMLConfig.MAX_FLOATING_RAILS.get(); ++i) {
            BlockState state = level.getBlockState(pos.relative(direction, i));
            if (!(state.getBlock() instanceof BaseRailBlock)) {
                return true;
            }
            RailShape offsetShape = (RailShape)state.getValue(((BaseRailBlock)state.getBlock()).getShapeProperty());
            if (Block.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.relative(direction, i).below())) {
                return false;
            }
            if (offsetShape == shape) continue;
            return true;
        }
        return true;
    }

    @Unique
    private static boolean nml$shouldBeRemovedOverride(BlockPos pos, LevelReader level, RailShape shape) {
        if (!Block.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.below())) {
            return switch (shape) {
                case RailShape.NORTH_SOUTH -> {
                    if (BaseRailBlockMixin.nml$floatingRails(pos, level, shape, Direction.NORTH) && BaseRailBlockMixin.nml$floatingRails(pos, level, shape, Direction.SOUTH)) {
                        yield true;
                    }
                    yield false;
                }
                case RailShape.EAST_WEST -> {
                    if (BaseRailBlockMixin.nml$floatingRails(pos, level, shape, Direction.EAST) && BaseRailBlockMixin.nml$floatingRails(pos, level, shape, Direction.WEST)) {
                        yield true;
                    }
                    yield false;
                }
                default -> true;
            };
        }
        return switch (shape) {
            case RailShape.ASCENDING_EAST -> {
                if (!Block.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.east())) {
                    yield true;
                }
                yield false;
            }
            case RailShape.ASCENDING_WEST -> {
                if (!Block.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.west())) {
                    yield true;
                }
                yield false;
            }
            case RailShape.ASCENDING_NORTH -> {
                if (!Block.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.north())) {
                    yield true;
                }
                yield false;
            }
            case RailShape.ASCENDING_SOUTH -> {
                if (!Block.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.south())) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    protected void getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        EntityCollisionContext entityCollisionContext;
        if (!(((RailShape)state.getValue(this.getShapeProperty())).isAscending() || context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context).getEntity() != null && entityCollisionContext.getEntity() instanceof AbstractMinecart)) {
            cir.setReturnValue((Object)this.getShape(state, level, pos, context));
        }
    }

    @Inject(method={"canSurvive"}, at={@At(value="HEAD")}, cancellable=true)
    private void nml$canSurvive(BlockState state, LevelReader level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        RailShape railshape = null;
        if (state != null && state.hasProperty(this.getShapeProperty())) {
            railshape = (RailShape)state.getValue(this.getShapeProperty());
        }
        if (railshape != null) {
            cir.setReturnValue((Object)(!BaseRailBlockMixin.nml$shouldBeRemovedOverride(pos, level, railshape) ? 1 : 0));
        }
    }

    @Inject(method={"shouldBeRemoved"}, at={@At(value="HEAD")}, cancellable=true)
    private static void nml$shouldBeRemoved(BlockPos pos, Level level, RailShape shape, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)BaseRailBlockMixin.nml$shouldBeRemovedOverride(pos, (LevelReader)level, shape));
    }
}

