/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.mixin;

import com.farcr.nomansland.common.world.densityfunction.modification.DensityFunctionModifications;
import com.farcr.nomansland.common.world.densityfunction.modification.DensityFunctionModifier;
import com.farcr.nomansland.common.world.densityfunction.modification.NoiseRouterParameter;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={MinecraftServer.class})
public class MinecraftServerMixin {
    @WrapOperation(method={"createLevels"}, at={@At(value="NEW", target="net/minecraft/server/level/ServerLevel")})
    private ServerLevel nml$modifyNoiseRouter(MinecraftServer server, Executor workerExecutor, LevelStorageSource.LevelStorageAccess session, ServerLevelData properties, ResourceKey<Level> worldKey, LevelStem dimensionOptions, ChunkProgressListener worldGenerationProgressListener, boolean debugWorld, long seed, List<CustomSpawner> spawners, boolean shouldTickTime, @Nullable RandomSequences randomSequencesState, Operation<ServerLevel> operation) {
        Optional dimensionKey = dimensionOptions.type().unwrapKey();
        if (dimensionKey.isPresent() && DensityFunctionModifications.NOISE_ROUTER_MODIFICATIONS.containsKey(dimensionKey.get())) {
            DensityFunctionModifications.NoiseRouterModifications noiseRouterModifications = DensityFunctionModifications.NOISE_ROUTER_MODIFICATIONS.get(dimensionKey.get());
            ChunkGenerator chunkGenerator = dimensionOptions.generator();
            if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
                NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
                NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)noiseBasedChunkGenerator.generatorSettings().value();
                NoiseRouter noiseRouter = noiseGeneratorSettings.noiseRouter();
                for (Map.Entry<NoiseRouterParameter, DensityFunctionModifier> entry : noiseRouterModifications.modifiers.entrySet()) {
                    entry.getKey().modify(noiseRouter, entry.getValue());
                }
            }
        }
        return (ServerLevel)operation.call(new Object[]{server, workerExecutor, session, properties, worldKey, dimensionOptions, worldGenerationProgressListener, debugWorld, seed, spawners, shouldTickTime, randomSequencesState});
    }
}

