/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.registry.entities;

import com.farcr.nomansland.common.entity.Ember;
import com.farcr.nomansland.common.entity.IncendiaryArrow;
import com.farcr.nomansland.common.entity.InkCloud;
import com.farcr.nomansland.common.entity.LingeringCloud;
import com.farcr.nomansland.common.entity.PacifiedCloud;
import com.farcr.nomansland.common.entity.billhook_bass.BillhookBass;
import com.farcr.nomansland.common.entity.bombs.Explosive;
import com.farcr.nomansland.common.entity.bombs.Firebomb;
import com.farcr.nomansland.common.entity.bombs.InkBomb;
import com.farcr.nomansland.common.entity.bombs.LivingUrn;
import com.farcr.nomansland.common.entity.deer.Deer;
import com.farcr.nomansland.common.entity.goose.Goose;
import com.farcr.nomansland.common.entity.moose.Moose;
import com.farcr.nomansland.common.entity.tortoise.Tortoise;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NMLEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"nomansland");
    public static final Supplier<EntityType<Firebomb>> FIREBOMB = ENTITIES.register("firebomb", () -> EntityType.Builder.of(Firebomb::new, (MobCategory)MobCategory.MISC).sized(0.375f, 0.375f).clientTrackingRange(4).updateInterval(20).build("firebomb"));
    public static final Supplier<EntityType<InkBomb>> INK_BOMB = ENTITIES.register("ink_bomb", () -> EntityType.Builder.of(InkBomb::new, (MobCategory)MobCategory.MISC).sized(0.375f, 0.375f).clientTrackingRange(4).updateInterval(20).build("ink_bomb"));
    public static final Supplier<EntityType<Explosive>> EXPLOSIVE = ENTITIES.register("explosive", () -> EntityType.Builder.of(Explosive::new, (MobCategory)MobCategory.MISC).sized(0.3f, 0.3f).clientTrackingRange(4).updateInterval(20).build("explosive"));
    public static final Supplier<EntityType<LivingUrn>> LIVING_URN = ENTITIES.register("living_urn", () -> EntityType.Builder.of(LivingUrn::new, (MobCategory)MobCategory.MISC).sized(0.375f, 0.375f).clientTrackingRange(4).updateInterval(20).build("living_urn"));
    public static final Supplier<EntityType<IncendiaryArrow>> INCENDIARY_ARROW = ENTITIES.register("incendiary_arrow", () -> EntityType.Builder.of(IncendiaryArrow::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).eyeHeight(0.13f).clientTrackingRange(4).updateInterval(20).build("incendiary_arrow"));
    public static final Supplier<EntityType<Ember>> EMBER = ENTITIES.register("ember", () -> EntityType.Builder.of(Ember::new, (MobCategory)MobCategory.MISC).fireImmune().sized(1.0f, 1.0f).clientTrackingRange(10).updateInterval(Integer.MAX_VALUE).build("ember"));
    public static final Supplier<EntityType<LingeringCloud>> LINGERING_CLOUD = ENTITIES.register("lingering_cloud", () -> EntityType.Builder.of(LingeringCloud::new, (MobCategory)MobCategory.MISC).fireImmune().sized(6.0f, 6.0f).clientTrackingRange(10).updateInterval(Integer.MAX_VALUE).build("lingering_cloud"));
    public static final Supplier<EntityType<InkCloud>> INK_CLOUD = ENTITIES.register("ink_cloud", () -> EntityType.Builder.of(InkCloud::new, (MobCategory)MobCategory.MISC).fireImmune().sized(6.0f, 6.0f).clientTrackingRange(10).updateInterval(Integer.MAX_VALUE).build("ink_cloud"));
    public static final Supplier<EntityType<PacifiedCloud>> PACIFIED_CLOUD = ENTITIES.register("pacified_cloud", () -> EntityType.Builder.of(PacifiedCloud::new, (MobCategory)MobCategory.MISC).fireImmune().sized(6.0f, 6.0f).clientTrackingRange(10).updateInterval(Integer.MAX_VALUE).build("pacified_cloud"));
    public static final Supplier<EntityType<BillhookBass>> BILLHOOK_BASS = NMLEntities.register("billhook_bass", BillhookBass::new, MobCategory.WATER_CREATURE, 0.7f, 0.5f);
    public static final Supplier<EntityType<Deer>> DEER = NMLEntities.register("deer", Deer::new, MobCategory.CREATURE, 0.8f, 1.4f);
    public static final Supplier<EntityType<Goose>> GOOSE = NMLEntities.register("goose", Goose::new, MobCategory.CREATURE, 0.6f, 0.9f);
    public static final Supplier<EntityType<Moose>> MOOSE = NMLEntities.register("moose", Moose::new, MobCategory.CREATURE, 1.5f, 2.5f);
    public static final Supplier<EntityType<Tortoise>> TORTOISE = ENTITIES.register("tortoise", () -> EntityType.Builder.of(Tortoise::new, (MobCategory)MobCategory.CREATURE).sized(1.25f, 1.25f).eyeHeight(1.0f).passengerAttachments(new Vec3[]{new Vec3(0.0, 1.15, 0.0)}).build("tortoise"));

    public static <T extends Entity> Supplier<EntityType<T>> register(String name, EntityType.EntityFactory<T> entity, MobCategory category, float width, float height) {
        return ENTITIES.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)entity, (MobCategory)category).sized(width, height).build(name));
    }
}

