/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.saved_data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.saveddata.SavedData;

public class WardedSpacesData
extends SavedData {
    public static final String NAME = "warded_spaces";
    public ArrayList<BlockPos> positions;
    public ArrayList<Integer> ranges;

    public WardedSpacesData(ArrayList<BlockPos> positions, ArrayList<Integer> ranges) {
        this.positions = positions;
        this.ranges = ranges;
    }

    public WardedSpacesData() {
        this.positions = new ArrayList();
        this.ranges = new ArrayList();
    }

    public static WardedSpacesData create(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        Arrays.stream(tag.getLongArray("positions")).forEachOrdered(pos -> positions.add(BlockPos.of((long)pos)));
        ArrayList<Integer> ranges = new ArrayList<Integer>();
        Arrays.stream(tag.getIntArray("ranges")).forEachOrdered(ranges::add);
        return new WardedSpacesData(positions, ranges);
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        ArrayList positions = new ArrayList();
        this.positions.forEach(pos -> positions.add(pos.asLong()));
        if (!positions.isEmpty()) {
            tag.putLongArray("positions", positions);
            tag.putIntArray("ranges", this.ranges);
        }
        return tag;
    }

    public void addEffigy(BlockPos pos, int range) {
        this.removeEffigy(pos);
        this.positions.add(pos);
        this.ranges.add(range);
        this.setDirty();
    }

    public void removeEffigy(BlockPos pos) {
        if (this.positions.contains(pos)) {
            this.ranges.remove(this.positions.indexOf(pos));
            this.positions.remove(pos);
            this.setDirty();
        }
    }

    public boolean isWarded(BlockPos pos) {
        if (this.positions.contains(pos)) {
            return true;
        }
        for (BlockPos wardedPos : this.positions) {
            if (!(wardedPos.distSqr((Vec3i)pos) <= (double)Mth.square((int)this.ranges.get(this.positions.indexOf(wardedPos))))) continue;
            return true;
        }
        return false;
    }

    public Optional<BlockPos> getAffectingEffigyAt(BlockPos pos) {
        if (this.positions.contains(pos)) {
            return Optional.of(pos);
        }
        BlockPos closestEffigy = null;
        for (BlockPos wardedPos : this.positions) {
            if (!(wardedPos.distSqr((Vec3i)pos) <= (double)Mth.square((int)this.ranges.get(this.positions.indexOf(wardedPos))))) continue;
            if (closestEffigy == null) {
                closestEffigy = wardedPos;
                continue;
            }
            if (!(wardedPos.distSqr((Vec3i)pos) < closestEffigy.distSqr((Vec3i)pos))) continue;
            closestEffigy = wardedPos;
        }
        return Optional.ofNullable(closestEffigy);
    }
}

