/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.world.biomemodifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public record ChangeSpawnsBiomeModifier(HolderSet<Biome> biomes, List<MobSpawnSettings.SpawnerData> spawners) implements BiomeModifier
{
    public static final MapCodec<ChangeSpawnsBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(ChangeSpawnsBiomeModifier::biomes), (App)MobSpawnSettings.SpawnerData.CODEC.listOf().fieldOf("spawners").forGetter(ChangeSpawnsBiomeModifier::spawners)).apply((Applicative)instance, ChangeSpawnsBiomeModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.BEFORE_EVERYTHING && this.biomes.contains(biome)) {
            MobSpawnSettingsBuilder spawnSettingsBuilder = builder.getMobSpawnSettings();
            this.spawners.forEach(spawner -> {
                for (MobCategory category : MobCategory.values()) {
                    List spawns = spawnSettingsBuilder.getSpawner(category);
                    if (!spawns.removeIf(spawnerData -> EntityType.getKey((EntityType)spawnerData.type).equals((Object)EntityType.getKey((EntityType)spawner.type)))) continue;
                    spawnSettingsBuilder.addSpawn(spawner.type.getCategory(), spawner);
                }
            });
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

